/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.rest.core.RepositoryConstraintViolationException;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.support.ETagDoesntMatchException;
import org.springframework.data.rest.webmvc.support.ExceptionMessage;
import org.springframework.data.rest.webmvc.support.RepositoryConstraintViolationExceptionMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackageClasses={RepositoryRestExceptionHandler.class})
public class RepositoryRestExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryRestExceptionHandler.class);
    private final MessageSourceAccessor messageSourceAccessor;

    public RepositoryRestExceptionHandler(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, (String)"MessageSource must not be null!");
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    @ExceptionHandler
    ResponseEntity<?> handleNotFound(ResourceNotFoundException o_O) {
        return this.notFound();
    }

    @ExceptionHandler
    ResponseEntity<ExceptionMessage> handleNotReadable(HttpMessageNotReadableException o_O) {
        return this.badRequest(o_O);
    }

    @ExceptionHandler(value={InvocationTargetException.class, IllegalArgumentException.class, ClassCastException.class, ConversionFailedException.class, NullPointerException.class})
    ResponseEntity<ExceptionMessage> handleMiscFailures(Exception o_O) {
        return this.errorResponse(null, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler
    ResponseEntity<RepositoryConstraintViolationExceptionMessage> handleRepositoryConstraintViolationException(RepositoryConstraintViolationException o_O) {
        return this.response(new HttpHeaders(), new RepositoryConstraintViolationExceptionMessage(o_O, this.messageSourceAccessor), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={OptimisticLockingFailureException.class, DataIntegrityViolationException.class})
    ResponseEntity<ExceptionMessage> handleConflict(Exception o_O) {
        return this.errorResponse(null, o_O, HttpStatus.CONFLICT);
    }

    @ExceptionHandler
    ResponseEntity<Void> handle(HttpRequestMethodNotSupportedException o_O) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(o_O.getSupportedHttpMethods());
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.METHOD_NOT_ALLOWED);
    }

    @ExceptionHandler
    ResponseEntity<Void> handle(ETagDoesntMatchException o_O) {
        HttpHeaders headers = o_O.getExpectedETag().addTo(new HttpHeaders());
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.PRECONDITION_FAILED);
    }

    private <T> ResponseEntity<T> notFound() {
        return this.notFound(new HttpHeaders(), null);
    }

    private <T> ResponseEntity<T> notFound(HttpHeaders headers, T body) {
        return this.response(headers, body, HttpStatus.NOT_FOUND);
    }

    private <T extends Exception> ResponseEntity<ExceptionMessage> badRequest(T throwable) {
        return this.badRequest(new HttpHeaders(), throwable);
    }

    private <T extends Exception> ResponseEntity<ExceptionMessage> badRequest(HttpHeaders headers, T throwable) {
        return this.errorResponse(headers, throwable, HttpStatus.BAD_REQUEST);
    }

    private <T extends Exception> ResponseEntity<ExceptionMessage> errorResponse(T throwable, HttpStatus status) {
        return this.errorResponse(new HttpHeaders(), throwable, status);
    }

    private <T extends Exception> ResponseEntity<ExceptionMessage> errorResponse(HttpHeaders headers, Exception exception, HttpStatus status) {
        if (null != exception && null != exception.getMessage()) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            return this.response(headers, new ExceptionMessage(exception), status);
        }
        return this.response(headers, null, status);
    }

    public <T> ResponseEntity<T> response(HttpHeaders headers, T body, HttpStatus status) {
        Assert.notNull((Object)headers, (String)"Headers must not be null!");
        Assert.notNull((Object)status, (String)"HttpStatus must not be null!");
        return new ResponseEntity(body, (MultiValueMap)headers, status);
    }
}

