/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.alps;

import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.hateoas.alps.Alps;
import org.springframework.hateoas.alps.Descriptor;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponentsBuilder;

@BasePathAwareController
public class AlpsController {
    static final String ALPS_ROOT_MAPPING = "/alps";
    static final String ALPS_RESOURCE_MAPPING = "/alps/{repository}";
    private final Repositories repositories;
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration configuration;

    @Autowired
    public AlpsController(Repositories repositories, ResourceMappings mappings, RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)configuration, (String)"MetadataConfiguration must not be null!");
        this.repositories = repositories;
        this.mappings = mappings;
        this.configuration = configuration;
    }

    @RequestMapping(value={"/alps", "/alps/{repository}"}, method={RequestMethod.OPTIONS})
    HttpEntity<?> alpsOptions() {
        this.verifyAlpsEnabled();
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/alps"}, method={RequestMethod.GET})
    HttpEntity<Alps> alps() {
        this.verifyAlpsEnabled();
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (Class domainType : this.repositories) {
            ResourceMetadata mapping = this.mappings.getMetadataFor(domainType);
            if (!mapping.isExported()) continue;
            BaseUri baseUri = new BaseUri(this.configuration.getBaseUri());
            UriComponentsBuilder builder = baseUri.getUriComponentsBuilder().path(ALPS_ROOT_MAPPING);
            String href = builder.path(mapping.getPath().toString()).build().toUriString();
            descriptors.add(Alps.descriptor().name(mapping.getRel()).href(href).build());
        }
        Alps alps = Alps.alps().descriptors(descriptors).build();
        return new ResponseEntity((Object)alps, HttpStatus.OK);
    }

    @RequestMapping(value={"/alps/{repository}"}, method={RequestMethod.GET})
    HttpEntity<RootResourceInformation> descriptor(RootResourceInformation information) {
        this.verifyAlpsEnabled();
        return new ResponseEntity((Object)information, HttpStatus.OK);
    }

    private void verifyAlpsEnabled() {
        if (!this.configuration.metadataConfiguration().alpsEnabled()) {
            throw new ResourceNotFoundException();
        }
    }
}

