/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.json.MappedProperties;
import org.springframework.data.rest.webmvc.support.DomainClassResolver;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;

public class JacksonMappingAwareSortTranslator {
    private final ObjectMapper objectMapper;
    private final Repositories repositories;
    private final DomainClassResolver domainClassResolver;

    public JacksonMappingAwareSortTranslator(ObjectMapper objectMapper, Repositories repositories, DomainClassResolver domainClassResolver) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null!");
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)domainClassResolver, (String)"DomainClassResolver must not be null!");
        this.objectMapper = objectMapper;
        this.repositories = repositories;
        this.domainClassResolver = domainClassResolver;
    }

    protected Sort translateSort(Sort input, MethodParameter parameter, NativeWebRequest webRequest) {
        Assert.notNull((Object)input, (String)"Sort must not be null!");
        Assert.notNull((Object)parameter, (String)"MethodParameter must not be null!");
        Assert.notNull((Object)webRequest, (String)"NativeWebRequest must not be null!");
        Class<?> domainClass = this.domainClassResolver.resolve(parameter.getMethod(), webRequest);
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity(domainClass);
        MappedProperties mappedProperties = MappedProperties.fromJacksonProperties(persistentEntity, this.objectMapper);
        return new SortTranslator(mappedProperties).translateSort(input);
    }

    static class SortTranslator {
        private final MappedProperties mappedProperties;

        public SortTranslator(MappedProperties mappedProperties) {
            Assert.notNull((Object)mappedProperties, (String)"MappedProperties must not be null!");
            this.mappedProperties = mappedProperties;
        }

        Sort translateSort(Sort input) {
            ArrayList<Sort.Order> filteredOrders = new ArrayList<Sort.Order>();
            for (Sort.Order order : input) {
                if (!this.mappedProperties.hasPersistentPropertyForField(order.getProperty())) continue;
                PersistentProperty<?> persistentProperty = this.mappedProperties.getPersistentProperty(order.getProperty());
                Sort.Order mappedOrder = new Sort.Order(order.getDirection(), persistentProperty.getName(), order.getNullHandling());
                filteredOrders.add(order.isIgnoreCase() ? mappedOrder.ignoreCase() : mappedOrder);
            }
            return filteredOrders.isEmpty() ? null : new Sort(filteredOrders);
        }
    }
}

