/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class RepositoryRestHandlerMapping
extends BasePathAwareHandlerMapping {
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration configuration;
    private final Repositories repositories;
    private RepositoryCorsConfigurationAccessor corsConfigurationAccessor;
    private JpaHelper jpaHelper;

    public RepositoryRestHandlerMapping(ResourceMappings mappings, RepositoryRestConfiguration config) {
        this(mappings, config, null);
    }

    public RepositoryRestHandlerMapping(ResourceMappings mappings, RepositoryRestConfiguration config, Repositories repositories) {
        super(config);
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        this.mappings = mappings;
        this.configuration = config;
        this.repositories = repositories;
        this.corsConfigurationAccessor = new RepositoryCorsConfigurationAccessor(mappings, NoOpStringValueResolver.INSTANCE, repositories);
    }

    public void setJpaHelper(JpaHelper jpaHelper) {
        this.jpaHelper = jpaHelper;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        super.setEmbeddedValueResolver(resolver);
        this.corsConfigurationAccessor = new RepositoryCorsConfigurationAccessor(this.mappings, resolver == null ? NoOpStringValueResolver.INSTANCE : resolver, this.repositories);
    }

    @Override
    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        HandlerMethod handlerMethod = super.lookupHandlerMethod(lookupPath, request);
        if (handlerMethod == null) {
            return null;
        }
        String repositoryLookupPath = new BaseUri(this.configuration.getBaseUri()).getRepositoryLookupPath(lookupPath);
        if (!StringUtils.hasText((String)repositoryLookupPath)) {
            return handlerMethod;
        }
        return this.mappings.exportsTopLevelResourceFor(RepositoryRestHandlerMapping.getRepositoryBasePath(repositoryLookupPath)) ? handlerMethod : null;
    }

    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> requestMappingInfos, String lookupPath, HttpServletRequest request) throws ServletException {
        return null;
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, RepositoryRestController.class) != null;
    }

    protected void extendInterceptors(List<Object> interceptors) {
        if (null != this.jpaHelper) {
            for (WebRequestInterceptor o : this.jpaHelper.getInterceptors()) {
                interceptors.add(o);
            }
        }
    }

    @Override
    protected ProducesRequestCondition customize(ProducesRequestCondition condition) {
        if (!condition.isEmpty()) {
            return condition;
        }
        LinkedHashSet<String> mediaTypes = new LinkedHashSet<String>();
        mediaTypes.add(this.configuration.getDefaultMediaType().toString());
        mediaTypes.add("application/json");
        return new ProducesRequestCondition(mediaTypes.toArray(new String[mediaTypes.size()]));
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        CorsConfiguration corsConfiguration = super.getCorsConfiguration(handler, request);
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        String repositoryLookupPath = new BaseUri(this.configuration.getBaseUri()).getRepositoryLookupPath(lookupPath);
        if (!StringUtils.hasText((String)repositoryLookupPath) || this.repositories == null) {
            return corsConfiguration;
        }
        CorsConfiguration repositoryCorsConfiguration = this.corsConfigurationAccessor.findCorsConfiguration(lookupPath);
        return corsConfiguration == null ? repositoryCorsConfiguration : corsConfiguration.combine(repositoryCorsConfiguration);
    }

    private static String getRepositoryBasePath(String repositoryLookupPath) {
        int secondSlashIndex = repositoryLookupPath.indexOf(47, repositoryLookupPath.startsWith("/") ? 1 : 0);
        return secondSlashIndex == -1 ? repositoryLookupPath : repositoryLookupPath.substring(0, secondSlashIndex);
    }

    static class RepositoryCorsConfigurationAccessor {
        @NonNull
        private final ResourceMappings mappings;
        @NonNull
        private final StringValueResolver embeddedValueResolver;
        private final Repositories repositories;

        CorsConfiguration findCorsConfiguration(String lookupPath) {
            ResourceMetadata resource = this.getResourceMetadata(RepositoryRestHandlerMapping.getRepositoryBasePath(lookupPath));
            return resource != null && this.repositories != null ? this.createConfiguration(this.repositories.getRepositoryInformationFor(resource.getDomainType()).getRepositoryInterface()) : null;
        }

        private ResourceMetadata getResourceMetadata(String basePath) {
            if (this.mappings.exportsTopLevelResourceFor(basePath)) {
                for (ResourceMetadata metadata : this.mappings) {
                    if (!metadata.getPath().matches(basePath) || !metadata.isExported()) continue;
                    return metadata;
                }
            }
            return null;
        }

        protected CorsConfiguration createConfiguration(Class<?> repositoryInterface) {
            CrossOrigin typeAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation(repositoryInterface, CrossOrigin.class);
            if (typeAnnotation == null) {
                return null;
            }
            CorsConfiguration config = new CorsConfiguration();
            this.updateCorsConfig(config, typeAnnotation);
            if (CollectionUtils.isEmpty((Collection)config.getAllowedOrigins())) {
                config.setAllowedOrigins(Arrays.asList(CrossOrigin.DEFAULT_ORIGINS));
            }
            if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
                for (HttpMethod httpMethod : HttpMethod.values()) {
                    config.addAllowedMethod(httpMethod);
                }
            }
            if (CollectionUtils.isEmpty((Collection)config.getAllowedHeaders())) {
                config.setAllowedHeaders(Arrays.asList(CrossOrigin.DEFAULT_ALLOWED_HEADERS));
            }
            if (config.getAllowCredentials() == null) {
                config.setAllowCredentials(Boolean.valueOf(true));
            }
            if (config.getMaxAge() == null) {
                config.setMaxAge(Long.valueOf(1800L));
            }
            return config;
        }

        private void updateCorsConfig(CorsConfiguration config, CrossOrigin annotation) {
            for (String string : annotation.origins()) {
                config.addAllowedOrigin(this.resolveCorsAnnotationValue(string));
            }
            for (String string : annotation.methods()) {
                config.addAllowedMethod(string.name());
            }
            for (String string : annotation.allowedHeaders()) {
                config.addAllowedHeader(this.resolveCorsAnnotationValue(string));
            }
            for (String string : annotation.exposedHeaders()) {
                config.addExposedHeader(this.resolveCorsAnnotationValue(string));
            }
            String allowCredentials = this.resolveCorsAnnotationValue(annotation.allowCredentials());
            if ("true".equalsIgnoreCase(allowCredentials)) {
                config.setAllowCredentials(Boolean.valueOf(true));
            } else if ("false".equalsIgnoreCase(allowCredentials)) {
                config.setAllowCredentials(Boolean.valueOf(false));
            } else if (!allowCredentials.isEmpty()) {
                throw new IllegalStateException("@CrossOrigin's allowCredentials value must be \"true\", \"false\", or an empty string (\"\"): current value is [" + allowCredentials + "]");
            }
            if (annotation.maxAge() >= 0L && config.getMaxAge() == null) {
                config.setMaxAge(Long.valueOf(annotation.maxAge()));
            }
        }

        private String resolveCorsAnnotationValue(String value) {
            return this.embeddedValueResolver.resolveStringValue(value);
        }

        @ConstructorProperties(value={"mappings", "embeddedValueResolver", "repositories"})
        public RepositoryCorsConfigurationAccessor(@NonNull ResourceMappings mappings, @NonNull StringValueResolver embeddedValueResolver, Repositories repositories) {
            if (mappings == null) {
                throw new IllegalArgumentException("mappings is null");
            }
            if (embeddedValueResolver == null) {
                throw new IllegalArgumentException("embeddedValueResolver is null");
            }
            this.mappings = mappings;
            this.embeddedValueResolver = embeddedValueResolver;
            this.repositories = repositories;
        }
    }

    static enum NoOpStringValueResolver implements StringValueResolver
    {
        INSTANCE;


        public String resolveStringValue(String value) {
            return value;
        }
    }
}

