/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

class SpelPath {
    private static final SpelExpressionParser SPEL_EXPRESSION_PARSER = new SpelExpressionParser();
    private static final List<String> APPEND_CHARACTERS = Arrays.asList("-", "~");
    private static final Map<String, SpelPath> PATHS = new ConcurrentReferenceHashMap(32);
    protected final String path;
    protected final Expression expression;

    private SpelPath(String path) {
        Assert.notNull((Object)path, (String)"Path must not be null!");
        this.path = path;
        this.expression = SPEL_EXPRESSION_PARSER.parseExpression(SpelPath.pathToSpEL(path));
    }

    public static SpelPath of(String source) {
        SpelPath path = PATHS.get(source);
        if (path == null) {
            path = new SpelPath(source);
            PATHS.put(source, path);
        }
        return path;
    }

    public TypedSpelPath bindTo(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return TypedSpelPath.of(this, type);
    }

    public Class<?> getLeafType(Class<?> type) {
        PropertyPath verifiedPath = TypedSpelPath.verifyPath(this.path, type);
        return verifiedPath == null ? type : verifiedPath.getType();
    }

    public boolean isAppend() {
        return this.path.endsWith("-");
    }

    private SpelPath getParent() {
        return SpelPath.of(this.path.substring(0, this.path.lastIndexOf(47)));
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!SpelPath.class.isInstance(obj)) {
            return false;
        }
        SpelPath that = (SpelPath)obj;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private static String pathToSpEL(String path) {
        return SpelPath.pathNodesToSpEL(path.split("\\/"));
    }

    private static String pathNodesToSpEL(String[] pathNodes) {
        StringBuilder spelBuilder = new StringBuilder();
        for (int i = 0; i < pathNodes.length; ++i) {
            String pathNode = pathNodes[i];
            if (pathNode.length() == 0) continue;
            if (APPEND_CHARACTERS.contains(pathNode)) {
                if (spelBuilder.length() > 0) {
                    spelBuilder.append(".");
                }
                spelBuilder.append("$[true]");
                continue;
            }
            try {
                int index = Integer.parseInt(pathNode);
                spelBuilder.append('[').append(index).append(']');
                continue;
            }
            catch (NumberFormatException e) {
                if (spelBuilder.length() > 0) {
                    spelBuilder.append('.');
                }
                spelBuilder.append(pathNode);
            }
        }
        String spel = spelBuilder.toString();
        if (spel.length() == 0) {
            spel = "#this";
        }
        return spel;
    }

    private SpelPath(String path, Expression expression) {
        this.path = path;
        this.expression = expression;
    }

    public String getPath() {
        return this.path;
    }

    static class TypedSpelPath
    extends SpelPath {
        private static final String INVALID_PATH_REFERENCE = "Invalid path reference %s on type %s (from source %s)!";
        private static final Map<CacheKey, TypedSpelPath> TYPED_PATHS = new ConcurrentReferenceHashMap(32);
        private static final EvaluationContext CONTEXT = SimpleEvaluationContext.forReadWriteDataBinding().build();
        private final Class<?> type;

        private TypedSpelPath(SpelPath path, Class<?> type) {
            super(path.path, path.expression);
            TypedSpelPath.verifyPath(path.path, type);
            this.type = type;
        }

        public static TypedSpelPath of(SpelPath path, Class<?> type) {
            Assert.notNull((Object)path, (String)"Path must not be null!");
            Assert.notNull(type, (String)"Type must not be null!");
            CacheKey key = CacheKey.of(type, path);
            TypedSpelPath result = TYPED_PATHS.get(key);
            if (result == null) {
                result = new TypedSpelPath(path, type);
                TYPED_PATHS.put(key, result);
            }
            return result;
        }

        public <T> T getValue(Object target) {
            Assert.notNull((Object)target, (String)"Target must not be null!");
            try {
                return (T)this.expression.getValue(CONTEXT, target);
            }
            catch (ExpressionException o_O) {
                throw new PatchException("Unable to get value from target", (Exception)((Object)o_O));
            }
        }

        public void setValue(Object target, Object value) {
            Assert.notNull((Object)target, (String)"Target must not be null!");
            this.expression.setValue(CONTEXT, target, value);
        }

        public Class<?> getType(Object root) {
            Assert.notNull((Object)root, (String)"Root object must not be null!");
            return this.expression.getValueType(CONTEXT, root);
        }

        public void copyFrom(SpelPath path, Object source) {
            Assert.notNull((Object)path, (String)"Source path must not be null!");
            Assert.notNull((Object)source, (String)"Source value must not be null!");
            this.addValue(source, path.bindTo(this.type).getValue(source));
        }

        public void moveFrom(SpelPath path, Object source) {
            Assert.notNull((Object)path, (String)"Source path must not be null!");
            Assert.notNull((Object)source, (String)"Source value must not be null!");
            this.addValue(source, path.bindTo(this.type).removeFrom(source));
        }

        public Object removeFrom(Object target) {
            Assert.notNull((Object)target, (String)"Target must not be null!");
            Integer listIndex = this.getTargetListIndex();
            Object value = this.getValue(target);
            if (listIndex == null) {
                try {
                    this.setValue(target, null);
                    return value;
                }
                catch (SpelEvaluationException o_O) {
                    throw new PatchException("Path '" + this.path + "' is not nullable.", (Exception)((Object)o_O));
                }
            }
            List list = (List)this.getParent().getValue(target);
            list.remove(listIndex >= 0 ? listIndex : list.size() - 1);
            return value;
        }

        public void addValue(Object target, Object value) {
            TypedSpelPath parentPath = this.getParent();
            Object parent = parentPath.getValue(target);
            Integer listIndex = this.getTargetListIndex();
            if (parent == null || !(parent instanceof List) || listIndex == null) {
                TypeDescriptor descriptor = parentPath.getTypeDescriptor(target);
                if (descriptor.isCollection() && !Collection.class.isInstance(value)) {
                    Collection collection = CollectionFactory.createCollection((Class)descriptor.getType(), (int)1);
                    collection.add(value);
                    parentPath.setValue(target, collection);
                } else {
                    this.setValue(target, value);
                }
            } else {
                List list = (List)parentPath.getValue(target);
                list.add(listIndex >= 0 ? listIndex.intValue() : list.size(), value);
            }
        }

        @Override
        private TypedSpelPath getParent() {
            return TypedSpelPath.of(((SpelPath)this).getParent(), this.type);
        }

        private TypeDescriptor getTypeDescriptor(Object target) {
            return this.expression.getValueTypeDescriptor(CONTEXT, target);
        }

        private Integer getTargetListIndex() {
            String lastNode = this.path.substring(this.path.lastIndexOf(47) + 1);
            if (APPEND_CHARACTERS.contains(lastNode)) {
                return -1;
            }
            try {
                return Integer.parseInt(lastNode);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private static PropertyPath verifyPath(String path, Class<?> type) {
            Assert.notNull((Object)path, (String)"Path must not be null!");
            Assert.notNull(type, (String)"Type must not be null!");
            String[] parts = path.split("/");
            ArrayList<String> result = new ArrayList<String>();
            for (String part : parts) {
                if (part.matches("\\d") || APPEND_CHARACTERS.contains(part) || part.isEmpty()) continue;
                result.add(part);
            }
            String pathSource = StringUtils.collectionToDelimitedString(result, (String)".");
            if (pathSource.isEmpty()) {
                return null;
            }
            try {
                return PropertyPath.from((String)pathSource, type);
            }
            catch (PropertyReferenceException o_O) {
                throw new PatchException(String.format(INVALID_PATH_REFERENCE, pathSource, type, path), (Exception)((Object)o_O));
            }
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypedSpelPath)) {
                return false;
            }
            TypedSpelPath other = (TypedSpelPath)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Class<?> this$type = this.type;
            Class<?> other$type = other.type;
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypedSpelPath;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Class<?> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        private static final class CacheKey {
            private final Class<?> type;
            private final SpelPath path;

            private CacheKey(Class<?> type, SpelPath path) {
                this.type = type;
                this.path = path;
            }

            public static CacheKey of(Class<?> type, SpelPath path) {
                return new CacheKey(type, path);
            }

            public Class<?> getType() {
                return this.type;
            }

            public SpelPath getPath() {
                return this.path;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)o;
                Class<?> this$type = this.getType();
                Class<?> other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                SpelPath this$path = this.getPath();
                SpelPath other$path = other.getPath();
                return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Class<?> $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                SpelPath $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
                return result;
            }

            public String toString() {
                return "SpelPath.TypedSpelPath.CacheKey(type=" + this.getType() + ", path=" + this.getPath() + ")";
            }
        }
    }
}

