/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.Ordered;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.auditing.MappingAuditableBeanWrapperFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.GeoModule;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.EnumTranslationConfiguration;
import org.springframework.data.rest.core.config.MetadataConfiguration;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AnnotatedEventHandlerInvoker;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.support.DefaultSelfLinkProvider;
import org.springframework.data.rest.core.support.DomainObjectMerger;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.core.support.RepositoryRelProvider;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.core.support.UnwrappingRepositoryInvokerFactory;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.EmbeddedResourcesAssembler;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.ProfileResourceProcessor;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestExceptionHandler;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerAdapter;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.ServerHttpRequestMethodArgumentResolver;
import org.springframework.data.rest.webmvc.alps.AlpsJsonHttpMessageConverter;
import org.springframework.data.rest.webmvc.alps.RootResourceInformationToAlpsDescriptorConverter;
import org.springframework.data.rest.webmvc.config.ArgumentResolverPagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceAssemblerArgumentResolver;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.ProjectionDefinitionRegistar;
import org.springframework.data.rest.webmvc.config.QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurerDelegate;
import org.springframework.data.rest.webmvc.config.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.convert.UriListHttpMessageConverter;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.data.rest.webmvc.json.EnumTranslator;
import org.springframework.data.rest.webmvc.json.Jackson2DatatypeHelper;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.rest.webmvc.json.JacksonSerializers;
import org.springframework.data.rest.webmvc.json.MappingAwareDefaultedPageableArgumentResolver;
import org.springframework.data.rest.webmvc.json.MappingAwarePageableArgumentResolver;
import org.springframework.data.rest.webmvc.json.MappingAwareSortArgumentResolver;
import org.springframework.data.rest.webmvc.json.PersistentEntityJackson2Module;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.mapping.LinkCollector;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.BackendIdHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.DefaultExcerptProjector;
import org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping;
import org.springframework.data.rest.webmvc.support.DomainClassResolver;
import org.springframework.data.rest.webmvc.support.ETagArgumentResolver;
import org.springframework.data.rest.webmvc.support.ExcerptProjector;
import org.springframework.data.rest.webmvc.support.HttpMethodHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.util.AnnotatedTypeScanner;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.PageableArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.SpringDataJacksonConfiguration;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.hateoas.mvc.ResourceProcessorInvoker;
import org.springframework.hateoas.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.plugin.core.OrderAwarePluginRegistry;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Configuration
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@ComponentScan(basePackageClasses={RepositoryRestController.class}, includeFilters={@ComponentScan.Filter(value={BasePathAwareController.class})}, useDefaultFilters=false)
@ImportResource(value={"classpath*:META-INF/spring-data-rest/**/*.xml"})
@Import(value={SpringDataJacksonConfiguration.class, EnableSpringDataWebSupport.QuerydslActivator.class})
public class RepositoryRestMvcConfiguration
extends HateoasAwareSpringDataWebConfiguration
implements InitializingBean {
    private static final boolean IS_JPA_AVAILABLE = ClassUtils.isPresent((String)"javax.persistence.EntityManager", (ClassLoader)RepositoryRestMvcConfiguration.class.getClassLoader());
    @Autowired
    ApplicationContext applicationContext;
    @Autowired(required=false)
    List<BackendIdConverter> idConverters = Collections.emptyList();
    @Autowired(required=false)
    List<RepositoryRestConfigurer> configurers = Collections.emptyList();
    @Autowired(required=false)
    List<EntityLookup<?>> lookups = Collections.emptyList();
    @Autowired(required=false)
    RelProvider relProvider;
    @Autowired(required=false)
    CurieProvider curieProvider;
    private RepositoryRestConfigurerDelegate configurerDelegate;
    @Autowired
    GeoModule geoModule;

    public void afterPropertiesSet() throws Exception {
        this.configurerDelegate = new RepositoryRestConfigurerDelegate(this.configurers);
    }

    @Bean
    public Repositories repositories() {
        return new Repositories((ListableBeanFactory)this.applicationContext);
    }

    @Bean
    public RepositoryRelProvider repositoryRelProvider(ObjectFactory<ResourceMappings> resourceMappings) {
        return new RepositoryRelProvider(resourceMappings);
    }

    @Bean
    public PersistentEntities persistentEntities() {
        ArrayList<MappingContext> arrayList = new ArrayList<MappingContext>();
        for (MappingContext context : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MappingContext.class).values()) {
            arrayList.add(context);
        }
        return new PersistentEntities(arrayList);
    }

    @Bean
    @Qualifier
    public DefaultFormattingConversionService defaultConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        conversionService.addConverter((GenericConverter)this.uriToEntityConverter((ConversionService)conversionService));
        this.addFormatters((FormatterRegistry)conversionService);
        this.configurerDelegate.configureConversionService((ConfigurableConversionService)conversionService);
        return conversionService;
    }

    @Bean
    public ValidatingRepositoryEventListener validatingRepositoryEventListener(ObjectFactory<PersistentEntities> entities) {
        ValidatingRepositoryEventListener listener = new ValidatingRepositoryEventListener(entities);
        this.configurerDelegate.configureValidatingRepositoryEventListener(listener);
        return listener;
    }

    @Bean
    public JpaHelper jpaHelper() {
        if (IS_JPA_AVAILABLE) {
            return new JpaHelper();
        }
        return null;
    }

    @Bean
    public RepositoryRestConfiguration config() {
        ProjectionDefinitionConfiguration configuration = new ProjectionDefinitionConfiguration();
        for (Class<?> projection : this.getProjections(this.repositories())) {
            configuration.addProjection(projection);
        }
        RepositoryRestConfiguration config = new RepositoryRestConfiguration(configuration, this.metadataConfiguration(), (EnumTranslationConfiguration)this.enumTranslator());
        this.configurerDelegate.configureRepositoryRestConfiguration(config);
        return config;
    }

    @Bean
    public static ProjectionDefinitionRegistar projectionDefinitionRegistrar(ObjectFactory<RepositoryRestConfiguration> config) {
        return new ProjectionDefinitionRegistar(config);
    }

    @Bean
    public MetadataConfiguration metadataConfiguration() {
        return new MetadataConfiguration();
    }

    @Bean
    public BaseUri baseUri() {
        return new BaseUri(this.config().getBaseUri());
    }

    @Bean
    public static AnnotatedEventHandlerInvoker annotatedEventHandlerInvoker() {
        return new AnnotatedEventHandlerInvoker();
    }

    @Bean
    public DomainObjectMerger domainObjectMerger() throws Exception {
        return new DomainObjectMerger(this.repositories(), (ConversionService)this.defaultConversionService());
    }

    @Bean
    public ServerHttpRequestMethodArgumentResolver serverHttpRequestMethodArgumentResolver() {
        return new ServerHttpRequestMethodArgumentResolver();
    }

    @Bean
    public RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver() {
        if (QueryDslUtils.QUERY_DSL_PRESENT) {
            QuerydslBindingsFactory factory = (QuerydslBindingsFactory)this.applicationContext.getBean(QuerydslBindingsFactory.class);
            QuerydslPredicateBuilder predicateBuilder = new QuerydslPredicateBuilder((ConversionService)this.defaultConversionService(), factory.getEntityPathResolver());
            return new QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(this.repositories(), this.repositoryInvokerFactory((ConversionService)this.defaultConversionService()), this.resourceMetadataHandlerMethodArgumentResolver(), predicateBuilder, factory);
        }
        return new RootResourceInformationHandlerMethodArgumentResolver(this.repositories(), this.repositoryInvokerFactory((ConversionService)this.defaultConversionService()), this.resourceMetadataHandlerMethodArgumentResolver());
    }

    @Bean
    public ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver() {
        return new ResourceMetadataHandlerMethodArgumentResolver(this.repositories(), (ResourceMappings)this.resourceMappings(), this.baseUri());
    }

    @Bean
    public BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver() {
        return new BackendIdHandlerMethodArgumentResolver(this.backendIdConverterRegistry(), this.resourceMetadataHandlerMethodArgumentResolver(), this.baseUri());
    }

    @Bean
    public ETagArgumentResolver eTagArgumentResolver() {
        return new ETagArgumentResolver();
    }

    @Bean
    public RepositoryEntityLinks entityLinks() {
        ArgumentResolverPagingAndSortingTemplateVariables templateVariables = new ArgumentResolverPagingAndSortingTemplateVariables(this.pageableResolver(), this.sortResolver());
        return new RepositoryEntityLinks(this.repositories(), (ResourceMappings)this.resourceMappings(), this.config(), templateVariables, this.backendIdConverterRegistry());
    }

    @Bean
    public PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver() {
        return new PersistentEntityResourceHandlerMethodArgumentResolver(this.defaultMessageConverters(), this.repoRequestArgumentResolver(), this.backendIdHandlerMethodArgumentResolver(), new DomainObjectReader(this.persistentEntities(), this.associationLinks()));
    }

    @Bean
    public PersistentEntityToJsonSchemaConverter jsonSchemaConverter() {
        return new PersistentEntityToJsonSchemaConverter(this.persistentEntities(), this.associationLinks(), this.resourceDescriptionMessageSourceAccessor(), this.objectMapper(), this.config(), new PersistentEntityToJsonSchemaConverter.ValueTypeSchemaPropertyCustomizerFactory(this.repositoryInvokerFactory((ConversionService)this.defaultConversionService())));
    }

    @Bean
    public MessageSourceAccessor resourceDescriptionMessageSourceAccessor() {
        try {
            PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
            propertiesFactoryBean.setLocation((Resource)new ClassPathResource("rest-default-messages.properties"));
            propertiesFactoryBean.afterPropertiesSet();
            ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
            messageSource.setBasename("classpath:rest-messages");
            messageSource.setCommonMessages(propertiesFactoryBean.getObject());
            messageSource.setDefaultEncoding("UTF-8");
            return new MessageSourceAccessor((MessageSource)messageSource);
        }
        catch (Exception o_O) {
            throw new BeanCreationException("resourceDescriptionMessageSourceAccessor", "", (Throwable)o_O);
        }
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = this.basicObjectMapper();
        mapper.registerModule(this.persistentEntityJackson2Module());
        return mapper;
    }

    @Bean
    public TypeConstrainedMappingJackson2HttpMessageConverter jacksonHttpMessageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        if (!this.config().useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = this.config().useHalAsDefaultJsonMediaType() ? 0x7FFFFFFE : 0x7FFFFFF5;
        mediaTypes.addAll(Arrays.asList(RestMediaTypes.SCHEMA_JSON, RestMediaTypes.JSON_PATCH_JSON, RestMediaTypes.MERGE_PATCH_JSON, RestMediaTypes.SPRING_DATA_VERBOSE_JSON, RestMediaTypes.SPRING_DATA_COMPACT_JSON));
        ResourceSupportHttpMessageConverter jacksonConverter = new ResourceSupportHttpMessageConverter(order);
        jacksonConverter.setObjectMapper(this.objectMapper());
        jacksonConverter.setSupportedMediaTypes(mediaTypes);
        return jacksonConverter;
    }

    @Bean
    public TypeConstrainedMappingJackson2HttpMessageConverter halJacksonHttpMessageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaTypes.HAL_JSON);
        if (this.config().useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = this.config().useHalAsDefaultJsonMediaType() ? 0x7FFFFFF5 : 0x7FFFFFFE;
        ResourceSupportHttpMessageConverter converter = new ResourceSupportHttpMessageConverter(order);
        converter.setObjectMapper(this.halObjectMapper());
        converter.setSupportedMediaTypes(mediaTypes);
        return converter;
    }

    @Bean
    public ObjectMapper halObjectMapper() {
        RelProvider defaultedRelProvider = this.relProvider != null ? this.relProvider : new EvoInflectorRelProvider();
        Jackson2HalModule.HalHandlerInstantiator instantiator = new Jackson2HalModule.HalHandlerInstantiator(defaultedRelProvider, this.curieProvider, this.resourceDescriptionMessageSourceAccessor(), this.applicationContext.getAutowireCapableBeanFactory());
        ObjectMapper mapper = this.basicObjectMapper();
        mapper.registerModule(this.persistentEntityJackson2Module());
        mapper.registerModule((Module)new Jackson2HalModule());
        mapper.setHandlerInstantiator((HandlerInstantiator)instantiator);
        return mapper;
    }

    @Bean
    public UriListHttpMessageConverter uriListHttpMessageConverter() {
        return new UriListHttpMessageConverter();
    }

    @Bean
    public ResourceProcessorInvoker resourceProcessorInvoker() {
        Collection beans = this.applicationContext.getBeansOfType(ResourceProcessor.class, false, false).values();
        ArrayList<ResourceProcessor> processors = new ArrayList<ResourceProcessor>(beans.size());
        for (ResourceProcessor bean : beans) {
            processors.add(bean);
        }
        return new ResourceProcessorInvoker(processors);
    }

    @Bean
    public RequestMappingHandlerAdapter repositoryExporterHandlerAdapter() {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService((ConversionService)this.defaultConversionService());
        RepositoryRestHandlerAdapter handlerAdapter = new RepositoryRestHandlerAdapter(this.defaultMethodArgumentResolvers(), this.resourceProcessorInvoker());
        handlerAdapter.setWebBindingInitializer((WebBindingInitializer)initializer);
        handlerAdapter.setMessageConverters(this.defaultMessageConverters());
        if (this.config().getMetadataConfiguration().alpsEnabled()) {
            handlerAdapter.setResponseBodyAdvice(Arrays.asList(new ResponseBodyAdvice[]{this.alpsJsonHttpMessageConverter()}));
        }
        return handlerAdapter;
    }

    @Bean
    public DelegatingHandlerMapping restHandlerMapping() {
        Map corsConfigurations = this.config().getCorsRegistry().getCorsConfigurations();
        RepositoryRestHandlerMapping repositoryMapping = new RepositoryRestHandlerMapping((ResourceMappings)this.resourceMappings(), this.config(), this.repositories());
        repositoryMapping.setJpaHelper(this.jpaHelper());
        repositoryMapping.setApplicationContext(this.applicationContext);
        repositoryMapping.setCorsConfigurations(corsConfigurations);
        repositoryMapping.afterPropertiesSet();
        BasePathAwareHandlerMapping basePathMapping = new BasePathAwareHandlerMapping(this.config());
        basePathMapping.setApplicationContext(this.applicationContext);
        basePathMapping.setCorsConfigurations(corsConfigurations);
        basePathMapping.afterPropertiesSet();
        ArrayList<HandlerMapping> mappings = new ArrayList<HandlerMapping>();
        mappings.add((HandlerMapping)basePathMapping);
        mappings.add((HandlerMapping)repositoryMapping);
        return new DelegatingHandlerMapping(mappings);
    }

    @Bean
    public RepositoryResourceMappings resourceMappings() {
        return new RepositoryResourceMappings(this.repositories(), this.persistentEntities(), this.config());
    }

    protected Module persistentEntityJackson2Module() {
        PersistentEntities entities = this.persistentEntities();
        DefaultFormattingConversionService conversionService = this.defaultConversionService();
        UriToEntityConverter uriToEntityConverter = this.uriToEntityConverter((ConversionService)conversionService);
        RepositoryInvokerFactory repositoryInvokerFactory = this.repositoryInvokerFactory((ConversionService)conversionService);
        EmbeddedResourcesAssembler assembler = new EmbeddedResourcesAssembler(entities, this.associationLinks(), this.excerptProjector());
        PersistentEntityJackson2Module.LookupObjectSerializer lookupObjectSerializer = new PersistentEntityJackson2Module.LookupObjectSerializer((PluginRegistry<EntityLookup<?>, Class<?>>)OrderAwarePluginRegistry.create(this.getEntityLookups()));
        return new PersistentEntityJackson2Module(this.associationLinks(), entities, uriToEntityConverter, this.linkCollector(), repositoryInvokerFactory, lookupObjectSerializer, this.resourceProcessorInvoker(), assembler);
    }

    @Bean
    protected LinkCollector linkCollector() {
        return new LinkCollector(this.persistentEntities(), this.selfLinkProvider(), this.associationLinks());
    }

    protected UriToEntityConverter uriToEntityConverter(ConversionService conversionService) {
        return new UriToEntityConverter(this.persistentEntities(), this.repositoryInvokerFactory(conversionService), this.repositories());
    }

    @Bean
    public ExcerptProjector excerptProjector() {
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.setBeanFactory((BeanFactory)this.applicationContext);
        projectionFactory.setResourceLoader((ResourceLoader)this.applicationContext);
        return new DefaultExcerptProjector((ProjectionFactory)projectionFactory, (ResourceMappings)this.resourceMappings());
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        ExceptionHandlerExceptionResolver er = new ExceptionHandlerExceptionResolver();
        er.setCustomArgumentResolvers(this.defaultMethodArgumentResolvers());
        er.setMessageConverters(this.defaultMessageConverters());
        this.configurerDelegate.configureExceptionHandlerExceptionResolver(er);
        er.afterPropertiesSet();
        exceptionResolvers.add(0, (HandlerExceptionResolver)er);
    }

    @Bean
    public RepositoryRestExceptionHandler repositoryRestExceptionHandler() {
        return new RepositoryRestExceptionHandler((MessageSource)this.applicationContext);
    }

    @Bean
    public RepositoryInvokerFactory repositoryInvokerFactory(@Qualifier ConversionService defaultConversionService) {
        return new UnwrappingRepositoryInvokerFactory((RepositoryInvokerFactory)new DefaultRepositoryInvokerFactory(this.repositories(), defaultConversionService), this.getEntityLookups());
    }

    @Bean
    public List<HttpMessageConverter<?>> defaultMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        if (this.config().getMetadataConfiguration().alpsEnabled()) {
            messageConverters.add((HttpMessageConverter<?>)this.alpsJsonHttpMessageConverter());
        }
        if (this.config().getDefaultMediaType().equals((Object)MediaTypes.HAL_JSON)) {
            messageConverters.add((HttpMessageConverter<?>)this.halJacksonHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)this.jacksonHttpMessageConverter());
        } else {
            messageConverters.add((HttpMessageConverter<?>)this.jacksonHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)this.halJacksonHttpMessageConverter());
        }
        MappingJackson2HttpMessageConverter fallbackJsonConverter = new MappingJackson2HttpMessageConverter();
        fallbackJsonConverter.setObjectMapper(this.basicObjectMapper());
        messageConverters.add((HttpMessageConverter<?>)fallbackJsonConverter);
        messageConverters.add(this.uriListHttpMessageConverter());
        this.configurerDelegate.configureHttpMessageConverters(messageConverters);
        return messageConverters;
    }

    @Bean
    public AlpsJsonHttpMessageConverter alpsJsonHttpMessageConverter() {
        return new AlpsJsonHttpMessageConverter(this.alpsConverter());
    }

    @Bean
    public HateoasPageableHandlerMethodArgumentResolver pageableResolver() {
        HateoasPageableHandlerMethodArgumentResolver resolver = super.pageableResolver();
        resolver.setPageParameterName(this.config().getPageParamName());
        resolver.setSizeParameterName(this.config().getLimitParamName());
        resolver.setFallbackPageable((Pageable)new PageRequest(0, this.config().getDefaultPageSize()));
        resolver.setMaxPageSize(this.config().getMaxPageSize());
        return resolver;
    }

    @Bean
    public HateoasSortHandlerMethodArgumentResolver sortResolver() {
        HateoasSortHandlerMethodArgumentResolver resolver = super.sortResolver();
        resolver.setSortParameter(this.config().getSortParamName());
        return resolver;
    }

    @Bean
    public PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry() {
        ArrayList<BackendIdConverter> converters = new ArrayList<BackendIdConverter>(this.idConverters.size());
        converters.addAll(this.idConverters);
        converters.add(BackendIdConverter.DefaultIdConverter.INSTANCE);
        return OrderAwarePluginRegistry.create(converters);
    }

    @Bean
    public AuditableBeanWrapperFactory auditableBeanWrapperFactory() {
        return new MappingAuditableBeanWrapperFactory(this.persistentEntities());
    }

    @Bean
    public HttpHeadersPreparer httpHeadersPreparer() {
        return new HttpHeadersPreparer(this.auditableBeanWrapperFactory());
    }

    @Bean
    public SelfLinkProvider selfLinkProvider() {
        return new DefaultSelfLinkProvider(this.persistentEntities(), (EntityLinks)this.entityLinks(), this.getEntityLookups());
    }

    @Bean
    public Associations associationLinks() {
        return new Associations((ResourceMappings)this.resourceMappings(), this.config());
    }

    protected List<EntityLookup<?>> getEntityLookups() {
        ArrayList lookups = new ArrayList();
        lookups.addAll(this.config().getEntityLookups(this.repositories()));
        lookups.addAll(this.lookups);
        return lookups;
    }

    protected List<HandlerMethodArgumentResolver> defaultMethodArgumentResolvers() {
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.setBeanFactory((BeanFactory)this.applicationContext);
        projectionFactory.setResourceLoader((ResourceLoader)this.applicationContext);
        PersistentEntityResourceAssemblerArgumentResolver peraResolver = new PersistentEntityResourceAssemblerArgumentResolver(this.persistentEntities(), this.selfLinkProvider(), (ProjectionDefinitions)this.config().getProjectionConfiguration(), (ProjectionFactory)projectionFactory, this.associationLinks());
        HateoasPageableHandlerMethodArgumentResolver pageableResolver = this.pageableResolver();
        JacksonMappingAwareSortTranslator sortTranslator = new JacksonMappingAwareSortTranslator(this.objectMapper(), this.repositories(), DomainClassResolver.of(this.repositories(), (ResourceMappings)this.resourceMappings(), this.baseUri()), this.persistentEntities(), this.associationLinks());
        MappingAwareSortArgumentResolver sortResolver = new MappingAwareSortArgumentResolver(sortTranslator, (SortArgumentResolver)this.sortResolver());
        MappingAwarePageableArgumentResolver jacksonPageableResolver = new MappingAwarePageableArgumentResolver(sortTranslator, (PageableArgumentResolver)pageableResolver);
        MappingAwareDefaultedPageableArgumentResolver defaultedPageableResolver = new MappingAwareDefaultedPageableArgumentResolver(sortTranslator, (PageableHandlerMethodArgumentResolver)pageableResolver);
        return Arrays.asList(new HandlerMethodArgumentResolver[]{defaultedPageableResolver, jacksonPageableResolver, sortResolver, this.serverHttpRequestMethodArgumentResolver(), this.repoRequestArgumentResolver(), this.persistentEntityArgumentResolver(), this.resourceMetadataHandlerMethodArgumentResolver(), HttpMethodHandlerMethodArgumentResolver.INSTANCE, peraResolver, this.backendIdHandlerMethodArgumentResolver(), this.eTagArgumentResolver()});
    }

    protected ObjectMapper basicObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configurerDelegate.configureJacksonObjectMapper(objectMapper);
        objectMapper.registerModule((Module)this.geoModule);
        if (this.config().isEnableEnumTranslation()) {
            objectMapper.registerModule((Module)new JacksonSerializers(this.enumTranslator()));
        }
        Jackson2DatatypeHelper.configureObjectMapper(objectMapper);
        return objectMapper;
    }

    @Bean
    public EnumTranslator enumTranslator() {
        return new EnumTranslator(this.resourceDescriptionMessageSourceAccessor());
    }

    private Set<Class<?>> getProjections(Repositories repositories) {
        HashSet<String> packagesToScan = new HashSet<String>();
        for (Class domainType : repositories) {
            packagesToScan.add(domainType.getPackage().getName());
        }
        AnnotatedTypeScanner scanner = new AnnotatedTypeScanner(new Class[]{Projection.class});
        scanner.setEnvironment(this.applicationContext.getEnvironment());
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        return scanner.findTypes(packagesToScan);
    }

    @Bean
    public RootResourceInformationToAlpsDescriptorConverter alpsConverter() {
        Repositories repositories = this.repositories();
        PersistentEntities persistentEntities = this.persistentEntities();
        RepositoryEntityLinks entityLinks = this.entityLinks();
        MessageSourceAccessor messageSourceAccessor = this.resourceDescriptionMessageSourceAccessor();
        RepositoryRestConfiguration config = this.config();
        return new RootResourceInformationToAlpsDescriptorConverter(this.associationLinks(), repositories, persistentEntities, (EntityLinks)entityLinks, messageSourceAccessor, config, this.objectMapper(), this.enumTranslator());
    }

    @Bean
    public ProfileResourceProcessor profileResourceProcessor(RepositoryRestConfiguration config) {
        return new ProfileResourceProcessor(config);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (ClassUtils.isPresent((String)"org.springframework.data.rest.webmvc.halbrowser.HalBrowser", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
            String basePath = this.config().getBasePath().toString().concat("/browser");
            String rootLocation = "classpath:META-INF/spring-data-rest/hal-browser/";
            registry.addResourceHandler(new String[]{basePath.concat("/**")}).addResourceLocations(new String[]{rootLocation});
        }
    }

    private static class ResourceSupportHttpMessageConverter
    extends TypeConstrainedMappingJackson2HttpMessageConverter
    implements Ordered {
        private final int order;

        public ResourceSupportHttpMessageConverter(int order) {
            super(ResourceSupport.class);
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

