/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.Optional;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.ETagDoesntMatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ETag {
    public static final ETag NO_ETAG = new ETag(null);
    private final String value;

    private ETag(String value) {
        this.value = StringUtils.trimTrailingCharacter((String)StringUtils.trimLeadingCharacter((String)value, (char)'\"'), (char)'\"');
    }

    public static ETag from(String value) {
        return new ETag(value);
    }

    public static ETag from(Optional<String> value) {
        return value.map(ETag::new).orElse(NO_ETAG);
    }

    public static ETag from(PersistentEntityResource resource) {
        Assert.notNull((Object)((Object)resource), (String)"PersistentEntityResource must not be null!");
        return ETag.from(resource.getPersistentEntity(), resource.getContent());
    }

    public static ETag from(PersistentEntity<?, ? extends PersistentProperty<?>> entity, Object bean) {
        return ETag.getVersionInformation(entity, bean).map(ETag::from).orElse(NO_ETAG);
    }

    public void verify(PersistentEntity<?, ?> entity, Object target) {
        if (this == NO_ETAG || target == null) {
            return;
        }
        if (!this.equals(ETag.from(entity, target))) {
            throw new ETagDoesntMatchException(target, this);
        }
    }

    public boolean matches(PersistentEntity<?, ?> entity, Object target) {
        if (this == NO_ETAG || target == null) {
            return false;
        }
        return this.equals(ETag.from(entity, target));
    }

    public HttpHeaders addTo(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"HttpHeaders must not be null!");
        String stringValue = this.toString();
        if (stringValue == null) {
            return headers;
        }
        headers.setETag(stringValue);
        return headers;
    }

    public String toString() {
        return this.value == null ? null : "\"".concat(this.value).concat("\"");
    }

    private static Optional<String> getVersionInformation(PersistentEntity<?, ? extends PersistentProperty<?>> entity, Object bean) {
        Assert.notNull(entity, (String)"PersistentEntity must not be null!");
        Assert.notNull((Object)bean, (String)"Target bean must not be null!");
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(bean);
        return entity.getVersionProperty().flatMap(it -> accessor.getProperty(it)).map(Object::toString);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ETag)) {
            return false;
        }
        ETag other = (ETag)o;
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

