/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import org.springframework.data.rest.webmvc.json.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.SpelPath;
import org.springframework.util.Assert;

public abstract class PatchOperation {
    protected final String op;
    protected final SpelPath.UntypedSpelPath path;
    protected final Object value;

    public PatchOperation(String op, SpelPath.UntypedSpelPath path) {
        this(op, path, null);
    }

    protected PatchOperation(String op, SpelPath.UntypedSpelPath path, Object value) {
        Assert.hasText((String)op, (String)"Operation must not be null or empty!");
        Assert.notNull((Object)path, (String)"UntypedSpelPath must not be null!");
        this.op = op;
        this.path = path;
        this.value = value;
    }

    protected Object evaluateValueFromTarget(Object targetObject, Class<?> entityType) {
        return this.evaluate(this.path.bindTo(entityType).getType(targetObject));
    }

    protected final Object evaluate(Class<?> type) {
        return this.value instanceof LateObjectEvaluator ? ((LateObjectEvaluator)this.value).evaluate(type) : this.value;
    }

    abstract void perform(Object var1, Class<?> var2);
}

