/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.result.FacetFieldEntry;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.FacetQueryEntry;
import org.springframework.data.solr.core.query.result.SimpleFacetFieldEntry;
import org.springframework.data.solr.core.query.result.SimpleFacetQueryEntry;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResultHelper {
    private ResultHelper() {
    }

    static Map<Field, Page<FacetFieldEntry>> convertFacetQueryResponseToFacetPageMap(FacetQuery query, QueryResponse response) {
        Assert.notNull((Object)query, (String)"Cannot convert response for 'null', query");
        if (!ResultHelper.hasFacets(query, response)) {
            return Collections.emptyMap();
        }
        HashMap<Field, Page<FacetFieldEntry>> facetResult = new HashMap<Field, Page<FacetFieldEntry>>();
        if (CollectionUtils.isNotEmpty((Collection)response.getFacetFields())) {
            int initalPageSize = query.getFacetOptions().getPageable().getPageSize();
            for (FacetField facetField : response.getFacetFields()) {
                if (facetField == null || !StringUtils.isNotBlank((String)facetField.getName())) continue;
                SimpleField field = new SimpleField(facetField.getName());
                if (CollectionUtils.isNotEmpty((Collection)facetField.getValues())) {
                    ArrayList<SimpleFacetFieldEntry> pageEntries = new ArrayList<SimpleFacetFieldEntry>(initalPageSize);
                    for (FacetField.Count count : facetField.getValues()) {
                        if (count == null) continue;
                        pageEntries.add(new SimpleFacetFieldEntry(field, count.getName(), count.getCount()));
                    }
                    facetResult.put(field, (Page<FacetFieldEntry>)new FacetPage(pageEntries, query.getFacetOptions().getPageable(), facetField.getValueCount()));
                    continue;
                }
                facetResult.put(field, (Page<FacetFieldEntry>)new FacetPage(Collections.emptyList(), query.getFacetOptions().getPageable(), 0L));
            }
        }
        return facetResult;
    }

    static List<FacetQueryEntry> convertFacetQueryResponseToFacetQueryResult(FacetQuery query, QueryResponse response) {
        Assert.notNull((Object)query, (String)"Cannot convert response for 'null', query");
        if (!ResultHelper.hasFacets(query, response)) {
            return Collections.emptyList();
        }
        ArrayList<FacetQueryEntry> facetResult = new ArrayList<FacetQueryEntry>();
        if (MapUtils.isNotEmpty((Map)response.getFacetQuery())) {
            for (Map.Entry entry : response.getFacetQuery().entrySet()) {
                facetResult.add(new SimpleFacetQueryEntry((String)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
        }
        return facetResult;
    }

    private static boolean hasFacets(FacetQuery query, QueryResponse response) {
        return query.hasFacetOptions() && response != null;
    }
}

