/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.solr.UncategorizedSolrException;
import org.springframework.util.ClassUtils;

public class SolrExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        SolrServerException solrServerException;
        if (ex.getCause() instanceof SolrServerException && (solrServerException = (SolrServerException)ex.getCause()).getCause() instanceof SolrException) {
            SolrException solrException = (SolrException)solrServerException.getCause();
            if (solrException.getCause() != null && ClassUtils.getShortName(solrException.getCause().getClass()).equalsIgnoreCase("ParseException")) {
                return new InvalidDataAccessApiUsageException(solrException.getCause().getMessage(), solrException.getCause());
            }
            SolrException.ErrorCode errorCode = SolrException.ErrorCode.getErrorCode((int)solrException.code());
            switch (errorCode) {
                case NOT_FOUND: 
                case SERVICE_UNAVAILABLE: 
                case SERVER_ERROR: {
                    return new DataAccessResourceFailureException(solrException.getMessage(), (Throwable)solrException);
                }
                case FORBIDDEN: 
                case UNAUTHORIZED: {
                    return new PermissionDeniedDataAccessException(solrException.getMessage(), (Throwable)solrException);
                }
                case BAD_REQUEST: {
                    return new InvalidDataAccessApiUsageException(solrException.getMessage(), (Throwable)solrException);
                }
                case UNKNOWN: {
                    return new UncategorizedSolrException(solrException.getMessage(), (Throwable)solrException);
                }
            }
        }
        return null;
    }
}

