/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.solr.core.query.Update;
import org.springframework.data.solr.core.query.UpdateField;

final class SolrjConverters {
    private SolrjConverters() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SolrInputDocumentToObjectConverter<T>
    extends DocumentBinderConverter
    implements Converter<Map<String, ?>, T> {
        private Class<T> clazz;

        public SolrInputDocumentToObjectConverter(Class<T> clazz) {
            this(clazz, null);
        }

        public SolrInputDocumentToObjectConverter(Class<T> clazz, DocumentObjectBinder binder) {
            super(binder);
            this.clazz = clazz;
        }

        public T convert(Map<String, ?> source) {
            if (source == null) {
                return null;
            }
            SolrDocument document = new SolrDocument();
            document.putAll(source);
            return (T)this.documentObejctBinder.getBean(this.clazz, document);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateToSolrInputDocumentConverter
    implements Converter<Update, SolrInputDocument> {
        public SolrInputDocument convert(Update source) {
            if (source == null) {
                return null;
            }
            SolrInputDocument solrInputDocument = new SolrInputDocument();
            solrInputDocument.addField(source.getIdField().getName(), source.getIdField().getValue());
            for (UpdateField field : source.getUpdates()) {
                HashMap<String, Object> mapValue = new HashMap<String, Object>(1);
                mapValue.put(field.getAction().getSolrOperation(), field.getValue());
                solrInputDocument.addField(field.getName(), mapValue);
            }
            return solrInputDocument;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectToSolrInputDocumentConverter
    extends DocumentBinderConverter
    implements Converter<Object, SolrInputDocument> {
        public ObjectToSolrInputDocumentConverter(DocumentObjectBinder binder) {
            super(binder);
        }

        public SolrInputDocument convert(Object source) {
            if (source == null) {
                return null;
            }
            return this.documentObejctBinder.toSolrInputDocument(source);
        }
    }

    static abstract class DocumentBinderConverter {
        protected final DocumentObjectBinder documentObejctBinder;

        public DocumentBinderConverter(DocumentObjectBinder binder) {
            this.documentObejctBinder = binder != null ? binder : new DocumentObjectBinder();
        }
    }
}

