/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.geo;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.solr.core.geo.Distance;
import org.springframework.data.solr.core.geo.GeoLocation;

public final class GeoConverters {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistanceToStringConverter implements Converter<Distance, String>
    {
        INSTANCE;


        public String convert(Distance source) {
            if (source == null) {
                return null;
            }
            return String.format(Locale.ENGLISH, "%s", source.getNormalizedValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GeoLocationToStringConverter implements Converter<GeoLocation, String>
    {
        INSTANCE;


        public String convert(GeoLocation source) {
            if (source == null) {
                return null;
            }
            return StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", source.getLatitude()), (String)"0") + "," + StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", source.getLongitude()), (String)"0");
        }
    }
}

