/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.mapping;

import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.solrj.beans.Field;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSolrPersistentProperty
extends AnnotationBasedPersistentProperty<SolrPersistentProperty>
implements SolrPersistentProperty {
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();

    public SimpleSolrPersistentProperty(java.lang.reflect.Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, SolrPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
    }

    @Override
    public String getFieldName() {
        Field annotation = this.getField().getAnnotation(Field.class);
        if (annotation != null && StringUtils.hasText((String)annotation.value()) && !"#default".equals(annotation.value())) {
            return annotation.value();
        }
        return this.field.getName();
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.getFieldName());
    }

    protected Association<SolrPersistentProperty> createAssociation() {
        return null;
    }

    static {
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
    }
}

