/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.SolrDataQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Query
extends SolrDataQuery {
    public static final int DEFAULT_PAGE_SIZE = 10;

    public <T extends Query> T addProjectionOnField(Field var1);

    public <T extends Query> T setPageRequest(Pageable var1);

    public <T extends Query> T addGroupByField(Field var1);

    public <T extends Query> T addFilterQuery(FilterQuery var1);

    public List<FilterQuery> getFilterQueries();

    public Pageable getPageRequest();

    public List<Field> getGroupByFields();

    public List<Field> getProjectionOnFields();

    public <T extends Query> T addSort(Sort var1);

    public Sort getSort();

    public void setDefaultOperator(Operator var1);

    public Operator getDefaultOperator();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        AND("AND"),
        OR("OR"),
        NONE("");

        private String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String asQueryStringRepresentation() {
            return this.operator;
        }

        public String toString() {
            return this.asQueryStringRepresentation();
        }
    }
}

