/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.repository.support.SolrRepositoryFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<SolrOperations> solrOperationsBean;

    public SolrRepositoryBean(Bean<SolrOperations> operations, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager) {
        super(qualifiers, repositoryType, beanManager);
        Assert.notNull(operations, (String)"Cannot create repository with 'null' for SolrOperations.");
        this.solrOperationsBean = operations;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        SolrOperations solrOperations = (SolrOperations)this.getDependencyInstance(this.solrOperationsBean, SolrOperations.class);
        return (T)new SolrRepositoryFactory(solrOperations).getRepository(repositoryType);
    }

    public Class<? extends Annotation> getScope() {
        return this.solrOperationsBean.getScope();
    }
}

