/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleFacetQuery;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SimpleFilterQuery;
import org.springframework.data.solr.core.query.SimpleStringCriteria;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.query.SolrParameterAccessor;
import org.springframework.data.solr.repository.query.SolrParametersParameterAccessor;
import org.springframework.data.solr.repository.query.SolrQueryMethod;
import org.springframework.util.Assert;

public abstract class AbstractSolrQuery
implements RepositoryQuery {
    private final SolrOperations solrOperations;
    private final SolrQueryMethod solrQueryMethod;

    public AbstractSolrQuery(SolrOperations solrOperations, SolrQueryMethod solrQueryMethod) {
        Assert.notNull((Object)solrOperations);
        Assert.notNull((Object)((Object)solrQueryMethod));
        this.solrOperations = solrOperations;
        this.solrQueryMethod = solrQueryMethod;
    }

    public Object execute(Object[] parameters) {
        SolrParametersParameterAccessor accessor = new SolrParametersParameterAccessor(this.solrQueryMethod, parameters);
        Query query = this.createQuery(accessor);
        this.decorateWithFilterQuery(query);
        this.setDefaultQueryOperatorIfDefined(query);
        if (this.solrQueryMethod.isPageQuery()) {
            if (this.solrQueryMethod.isFacetQuery()) {
                FacetQuery facetQuery = SimpleFacetQuery.fromQuery(query, new SimpleFacetQuery());
                facetQuery.setFacetOptions(this.solrQueryMethod.getFacetOptions());
                return new FacetPageExecution(accessor.getPageable()).execute(facetQuery);
            }
            return new PagedExecution(accessor.getPageable()).execute(query);
        }
        if (this.solrQueryMethod.isCollectionQuery()) {
            return new CollectionExecution(accessor.getPageable()).execute(query);
        }
        return new SingleEntityExecution().execute(query);
    }

    private void setDefaultQueryOperatorIfDefined(Query query) {
        Query.Operator defaultOperator = this.solrQueryMethod.getDefaultOperator();
        if (defaultOperator != null && !Query.Operator.NONE.equals((Object)defaultOperator)) {
            query.setDefaultOperator(defaultOperator);
        }
    }

    private void decorateWithFilterQuery(Query query) {
        if (this.solrQueryMethod.hasFilterQuery()) {
            for (String filterQuery : this.solrQueryMethod.getFilterQueries()) {
                query.addFilterQuery(new SimpleFilterQuery(new SimpleStringCriteria(filterQuery)));
            }
        }
    }

    public SolrQueryMethod getQueryMethod() {
        return this.solrQueryMethod;
    }

    protected void appendProjection(Query query) {
        if (query != null && this.getQueryMethod().hasProjectionFields()) {
            for (String fieldname : this.getQueryMethod().getProjectionFields()) {
                query.addProjectionOnField(new SimpleField(fieldname));
            }
        }
    }

    protected abstract Query createQuery(SolrParameterAccessor var1);

    class SingleEntityExecution
    implements QueryExecution {
        SingleEntityExecution() {
        }

        public Object execute(Query query) {
            SolrEntityInformation<?, ?> metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForObject(query, metadata.getJavaType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FacetPageExecution
    extends PagedExecution {
        public FacetPageExecution(Pageable pageable) {
            super(pageable);
        }

        protected FacetPage<?> executeFind(Query query) {
            Assert.isInstanceOf(FacetQuery.class, (Object)query);
            SolrEntityInformation<?, ?> metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForFacetPage((FacetQuery)query, metadata.getJavaType());
        }
    }

    class PagedExecution
    extends AbstractQueryExecution {
        private final Pageable pageable;

        public PagedExecution(Pageable pageable) {
            Assert.notNull((Object)pageable);
            this.pageable = pageable;
        }

        public Object execute(Query query) {
            query.setPageRequest(this.getPageable());
            return this.executeFind(query);
        }

        protected Pageable getPageable() {
            return this.pageable;
        }
    }

    class CollectionExecution
    extends AbstractQueryExecution {
        private final Pageable pageable;

        public CollectionExecution(Pageable pageable) {
            this.pageable = pageable;
        }

        public Object execute(Query query) {
            query.setPageRequest((Pageable)(this.pageable != null ? this.pageable : new PageRequest(0, Math.max(1, (int)this.count(query)))));
            return this.executeFind(query).getContent();
        }

        private long count(Query query) {
            return AbstractSolrQuery.this.solrOperations.count(query);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractQueryExecution
    implements QueryExecution {
        AbstractQueryExecution() {
        }

        protected Page<?> executeFind(Query query) {
            SolrEntityInformation<?, ?> metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForPage(query, metadata.getJavaType());
        }
    }

    private static interface QueryExecution {
        public Object execute(Query var1);
    }
}

