/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.convert.DateTimeConverters;
import org.springframework.data.solr.core.convert.NumberConverters;
import org.springframework.data.solr.core.geo.Distance;
import org.springframework.data.solr.core.geo.GeoConverters;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SimpleStringCriteria;
import org.springframework.data.solr.repository.query.AbstractSolrQuery;
import org.springframework.data.solr.repository.query.SolrParameterAccessor;
import org.springframework.data.solr.repository.query.SolrQueryMethod;

public class StringBasedSolrQuery
extends AbstractSolrQuery {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private final String rawQueryString;
    private final GenericConversionService conversionService = new GenericConversionService();

    public StringBasedSolrQuery(SolrQueryMethod method, SolrOperations solrOperations) {
        this(method.getAnnotatedQuery(), method, solrOperations);
    }

    public StringBasedSolrQuery(String query, SolrQueryMethod queryMethod, SolrOperations solrOperations) {
        super(solrOperations, queryMethod);
        if (!this.conversionService.canConvert(Date.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(ReadableInstant.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(LocalDateTime.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Number.class, String.class)) {
            this.conversionService.addConverter((Converter)NumberConverters.NumberConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(GeoLocation.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.GeoLocationToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Distance.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.DistanceToStringConverter.INSTANCE);
        }
        this.rawQueryString = query;
    }

    protected Query createQuery(SolrParameterAccessor parameterAccessor) {
        String queryString = this.replacePlaceholders(this.rawQueryString, parameterAccessor);
        SimpleQuery query = new SimpleQuery(new SimpleStringCriteria(queryString));
        this.appendProjection(query);
        return query;
    }

    private String replacePlaceholders(String input, SolrParameterAccessor accessor) {
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String group = matcher.group();
            int index = Integer.parseInt(matcher.group(1));
            result = result.replace(group, this.getParameterWithIndex(accessor, index));
        }
        return result;
    }

    private String getParameterWithIndex(SolrParameterAccessor accessor, int index) {
        Object parameter = accessor.getBindableValue(index);
        if (parameter == null) {
            return "null";
        }
        if (this.conversionService.canConvert(parameter.getClass(), String.class)) {
            return (String)this.conversionService.convert(parameter, String.class);
        }
        if (parameter instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            for (Object o : (Collection)parameter) {
                if (this.conversionService.canConvert(o.getClass(), String.class)) {
                    sb.append((String)this.conversionService.convert(o, String.class));
                } else {
                    sb.append(o.toString());
                }
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return parameter.toString();
    }
}

