/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.solr.server.SolrServerFactory;
import org.springframework.util.Assert;

public class HttpSolrServerFactory
implements SolrServerFactory,
DisposableBean {
    private static final String SLASH = "/";
    private SolrServer solrServer;
    private String core;
    private Credentials credentials;
    private String authPolicy;

    protected HttpSolrServerFactory() {
    }

    public HttpSolrServerFactory(SolrServer solrServer) {
        this(solrServer, null);
    }

    public HttpSolrServerFactory(SolrServer solrServer, String core) {
        this(solrServer, core, null, null);
    }

    public HttpSolrServerFactory(SolrServer solrServer, String core, Credentials credentials, String authPolicy) {
        Assert.notNull((Object)solrServer, (String)"SolrServer must not be null");
        if (authPolicy != null) {
            Assert.hasText((String)authPolicy);
        }
        this.core = core;
        this.solrServer = solrServer;
        this.credentials = credentials;
        this.authPolicy = authPolicy;
        this.appendCoreToBaseUrl(this.core, this.solrServer);
        this.appendAuthentication(this.credentials, this.authPolicy, this.solrServer);
    }

    public SolrServer getSolrServer() {
        return this.solrServer;
    }

    public String getCore() {
        return this.core;
    }

    private void appendCoreToBaseUrl(String core, SolrServer solrServer) {
        if (StringUtils.isNotEmpty((String)core) && this.assertSolrServerInstance(solrServer)) {
            HttpSolrServer httpSolrServer = (HttpSolrServer)solrServer;
            String url = httpSolrServer.getBaseURL();
            if (!StringUtils.endsWith((String)SLASH, (String)url)) {
                url = url + SLASH;
            }
            url = url + core;
            httpSolrServer.setBaseURL(url);
        }
    }

    private void appendAuthentication(Credentials credentials, String authPolicy, SolrServer solrServer) {
        if (this.assertSolrServerInstance(solrServer)) {
            HttpSolrServer httpSolrServer = (HttpSolrServer)solrServer;
            if (credentials != null && StringUtils.isNotBlank((String)authPolicy) && this.assertHttpClientInstance(httpSolrServer.getHttpClient())) {
                AbstractHttpClient httpClient = (AbstractHttpClient)httpSolrServer.getHttpClient();
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY), credentials);
                httpClient.getParams().setParameter("http.auth.target-scheme-pref", Arrays.asList(authPolicy));
            }
        }
    }

    private boolean assertSolrServerInstance(SolrServer solrServer) {
        return solrServer instanceof HttpSolrServer;
    }

    private boolean assertHttpClientInstance(HttpClient httpClient) {
        Assert.isInstanceOf(AbstractHttpClient.class, (Object)httpClient, (String)"HttpClient has to be derivate of AbstractHttpClient in order to allow authentication.");
        return true;
    }

    public void destroy() {
        if (this.solrServer instanceof HttpSolrServer) {
            ((HttpSolrServer)this.solrServer).shutdown();
        }
    }

    protected void setSolrServer(SolrServer solrServer) {
        this.solrServer = solrServer;
    }
}

