/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.solr.server.support.HttpSolrServerFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSolrServerFactoryBean
extends HttpSolrServerFactory
implements FactoryBean<SolrServer>,
InitializingBean,
DisposableBean {
    private String url;
    private Integer timeout;
    private Integer maxConnections;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.url);
        this.initSolrServer();
    }

    private void initSolrServer() {
        HttpSolrServer httpSolrServer = new HttpSolrServer(this.url);
        if (this.timeout != null) {
            httpSolrServer.setConnectionTimeout(this.timeout.intValue());
        }
        if (this.maxConnections != null) {
            httpSolrServer.setMaxTotalConnections(this.maxConnections.intValue());
        }
        this.setSolrServer((SolrServer)httpSolrServer);
    }

    public SolrServer getObject() throws Exception {
        return this.getSolrServer();
    }

    public Class<?> getObjectType() {
        return HttpSolrServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }
}

