/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.solr.server.support.HttpSolrClientFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HttpSolrClientFactoryBean
extends HttpSolrClientFactory
implements FactoryBean<SolrClient>,
InitializingBean,
DisposableBean {
    private static final String SERVER_URL_SEPARATOR = ",";
    @Nullable
    private String url;
    @Nullable
    private Integer timeout;
    @Nullable
    private Integer maxConnections;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.url, (String)"Solr url must not be null nor empty!");
        this.initSolrClient();
    }

    private void initSolrClient() {
        if (this.url.contains(SERVER_URL_SEPARATOR)) {
            this.createLoadBalancedHttpSolrClient();
        } else {
            this.createHttpSolrClient();
        }
    }

    private void createHttpSolrClient() {
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder().withBaseSolrUrl(this.url);
        if (this.timeout != null) {
            builder = (HttpSolrClient.Builder)builder.withConnectionTimeout(this.timeout.intValue());
        }
        if (this.maxConnections != null) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("maxConnections", this.maxConnections.intValue());
            builder.withHttpClient((HttpClient)HttpClientUtil.createClient((SolrParams)params));
        }
        this.setSolrClient((SolrClient)builder.build());
    }

    private void createLoadBalancedHttpSolrClient() {
        LBHttpSolrClient.Builder builder = new LBHttpSolrClient.Builder().withBaseSolrUrls(StringUtils.split((String)this.url, (String)SERVER_URL_SEPARATOR));
        if (this.timeout != null) {
            builder.withConnectionTimeout(this.timeout.intValue());
        }
        this.setSolrClient((SolrClient)builder.build());
    }

    public SolrClient getObject() throws Exception {
        return this.getSolrClient();
    }

    public Class<?> getObjectType() {
        if (this.getSolrClient() == null) {
            return HttpSolrClient.class;
        }
        return this.getSolrClient().getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }
}

