/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.test.junit;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.yarn.boot.SpringApplicationCallback;
import org.springframework.yarn.boot.SpringApplicationTemplate;
import org.springframework.yarn.client.YarnClient;
import org.springframework.yarn.test.junit.AbstractYarnClusterTests;
import org.springframework.yarn.test.junit.ApplicationInfo;

public abstract class AbstractBootYarnClusterTests
extends AbstractYarnClusterTests {
    public void setYarnClient(YarnClient yarnClient) {
        super.setYarnClient(yarnClient);
    }

    protected ApplicationInfo submitApplicationAndWait(Object source, String[] args) throws Exception {
        return this.submitApplicationAndWait(source, args, 60L, TimeUnit.SECONDS);
    }

    protected ApplicationInfo submitApplicationAndWait(Object source, String[] args, long timeout, TimeUnit unit) throws Exception {
        return this.submitApplicationAndWaitState(source, args, timeout, unit, YarnApplicationState.FINISHED, YarnApplicationState.FAILED);
    }

    protected ApplicationInfo submitApplicationAndWaitState(Object source, String[] args, final long timeout, final TimeUnit unit, final YarnApplicationState ... applicationStates) throws Exception {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[]{source});
        builder.initializers(new ApplicationContextInitializer[]{new HadoopConfigurationInjectingInitializer(this.getConfiguration())});
        SpringApplicationTemplate template = new SpringApplicationTemplate(builder);
        return (ApplicationInfo)template.execute((SpringApplicationCallback)new SpringApplicationCallback<ApplicationInfo>(){

            public ApplicationInfo runWithSpringApplication(ApplicationContext context) throws Exception {
                AbstractBootYarnClusterTests.this.setYarnClient((YarnClient)context.getBean(YarnClient.class));
                return AbstractBootYarnClusterTests.this.submitApplicationAndWaitState(timeout, unit, applicationStates);
            }
        }, args);
    }

    private static class HadoopConfigurationInjectingInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final org.apache.hadoop.conf.Configuration configuration;

        public HadoopConfigurationInjectingInitializer(org.apache.hadoop.conf.Configuration configuration) {
            this.configuration = configuration;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.getBeanFactory().registerSingleton("miniYarnConfiguration", (Object)this.configuration);
        }
    }

    @Configuration
    public static class EmptyConfig {
    }
}

