/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot;

import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.condition.ConditionalOnYarnContainer;
import org.springframework.yarn.boot.properties.SpringHadoopProperties;
import org.springframework.yarn.boot.properties.SpringYarnContainerProperties;
import org.springframework.yarn.boot.properties.SpringYarnEnvProperties;
import org.springframework.yarn.boot.properties.SpringYarnProperties;
import org.springframework.yarn.boot.support.ContainerLauncherRunner;
import org.springframework.yarn.boot.support.ContainerRegistrar;
import org.springframework.yarn.config.annotation.EnableYarn;
import org.springframework.yarn.config.annotation.SpringYarnConfigurerAdapter;
import org.springframework.yarn.config.annotation.builders.YarnConfigConfigurer;
import org.springframework.yarn.config.annotation.builders.YarnContainerConfigurer;
import org.springframework.yarn.container.YarnContainer;

@Configuration
@ConditionalOnYarnContainer
@ConditionalOnClass(value={EnableYarn.class})
@ConditionalOnMissingBean(value={YarnContainer.class})
public class YarnContainerAutoConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={SpringHadoopProperties.class, SpringYarnProperties.class, SpringYarnEnvProperties.class, SpringYarnContainerProperties.class})
    @EnableYarn(enable=EnableYarn.Enable.CONTAINER)
    public static class SpringYarnConfig
    extends SpringYarnConfigurerAdapter {
        @Autowired
        private SpringYarnProperties syp;
        @Autowired
        private SpringHadoopProperties shp;
        @Autowired
        private SpringYarnContainerProperties sycp;
        @Autowired(required=false)
        @Qualifier(value="yarnContainerClass")
        private Class<? extends YarnContainer> yarnContainerClass;
        @Autowired(required=false)
        @Qualifier(value="yarnContainerRef")
        private Object yarnContainerRef;
        @Autowired(required=false)
        @Qualifier(value="customContainerClass")
        private String containerClass;

        public void configure(YarnConfigConfigurer config) throws Exception {
            ((YarnConfigConfigurer)config.fileSystemUri(this.shp.getFsUri()).withProperties().properties(this.shp.getConfig()).and()).withSecurity().namenodePrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getNamenodePrincipal() : null).rmManagerPrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getRmManagerPrincipal() : null).authMethod(this.shp.getSecurity() != null ? this.shp.getSecurity().getAuthMethod() : null).userPrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getUserPrincipal() : null).userKeytab(this.shp.getSecurity() != null ? this.shp.getSecurity().getUserKeytab() : null);
        }

        public void configure(YarnContainerConfigurer container) throws Exception {
            if (StringUtils.hasText((String)this.sycp.getContainerClass())) {
                container.containerClass(this.sycp.getContainerClass());
            } else if (this.yarnContainerClass != null) {
                container.containerClass(this.yarnContainerClass);
            } else if (this.yarnContainerRef != null) {
                if (this.yarnContainerRef instanceof YarnContainer) {
                    container.containerRef((YarnContainer)this.yarnContainerRef);
                }
            } else if (StringUtils.hasText((String)this.containerClass)) {
                container.containerClass(this.containerClass);
            }
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${endpoints.shutdown.enabled:false}")
    @EnableConfigurationProperties(value={SpringYarnEnvProperties.class})
    public static class ContainerRegistrarConfig {
        @Autowired
        private SpringYarnEnvProperties syep;

        @Bean
        public ContainerRegistrar containerRegistrar() {
            return new ContainerRegistrar(this.syep.getTrackUrl(), this.syep.getContainerId());
        }
    }

    @Configuration
    @ConditionalOnClass(value={JobLauncher.class})
    @ConditionalOnExpression(value="${spring.yarn.batch.enabled:false}")
    public static class RuntimeConfig {
        @Bean
        public String customContainerClass() {
            return "org.springframework.yarn.batch.container.DefaultBatchYarnContainer";
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={SpringYarnProperties.class, SpringYarnContainerProperties.class})
    public static class RunnerConfig {
        @Autowired
        private SpringYarnContainerProperties sycp;

        @Bean
        @ConditionalOnMissingBean(value={ContainerLauncherRunner.class})
        @ConditionalOnBean(value={YarnContainer.class})
        public ContainerLauncherRunner containerLauncherRunner() {
            ContainerLauncherRunner runner = new ContainerLauncherRunner();
            runner.setWaitLatch(this.sycp.isKeepContextAlive());
            return runner;
        }
    }
}

