/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.app;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointMBeanExportAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.yarn.boot.SpringApplicationCallback;
import org.springframework.yarn.boot.SpringApplicationTemplate;
import org.springframework.yarn.boot.app.AbstractClientApplication;
import org.springframework.yarn.boot.support.SpringYarnBootUtils;
import org.springframework.yarn.client.YarnClient;

@Configuration
@EnableAutoConfiguration(exclude={EmbeddedServletContainerAutoConfiguration.class, WebMvcAutoConfiguration.class, JmxAutoConfiguration.class, BatchAutoConfiguration.class, JmxAutoConfiguration.class, EndpointMBeanExportAutoConfiguration.class, EndpointAutoConfiguration.class})
public class YarnShutdownApplication
extends AbstractClientApplication<String, YarnShutdownApplication> {
    @Override
    public String run() {
        return this.run(new String[0]);
    }

    @Override
    public String run(String ... args) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[0]);
        builder.web(false);
        builder.sources(new Class[]{YarnShutdownApplication.class, OperationProperties.class});
        SpringYarnBootUtils.addSources(builder, this.sources.toArray(new Object[0]));
        SpringYarnBootUtils.addProfiles(builder, this.profiles.toArray(new String[0]));
        SpringYarnBootUtils.addApplicationListener(builder, this.appProperties);
        SpringApplicationTemplate template = new SpringApplicationTemplate(builder);
        return template.execute(new SpringApplicationCallback<String>(){

            @Override
            public String runWithSpringApplication(ApplicationContext context) throws Exception {
                OperationProperties operationProperties = (OperationProperties)context.getBean(OperationProperties.class);
                ApplicationId applicationId = ConverterUtils.toApplicationId((String)operationProperties.getApplicationId());
                YarnClient client = (YarnClient)context.getBean(YarnClient.class);
                ApplicationReport report = client.getApplicationReport(applicationId);
                String trackingUrl = report.getOriginalTrackingUrl();
                RestTemplate restTemplate = (RestTemplate)context.getBean("yarnRestTemplate", RestTemplate.class);
                restTemplate.postForObject(trackingUrl + "/shutdown", null, Void.class, new Object[0]);
                return "shutdown requested";
            }
        }, args);
    }

    @Override
    protected YarnShutdownApplication getThis() {
        return this;
    }

    @ConfigurationProperties(value="spring.yarn.internal.YarnShutdownApplication")
    public static class OperationProperties {
        String applicationId;

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getApplicationId() {
            return this.applicationId;
        }
    }
}

