/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.yarn.am.AppmasterTrackService;
import org.springframework.yarn.support.NetworkUtils;

public class EmbeddedAppmasterTrackService
implements AppmasterTrackService,
ApplicationListener<ApplicationEvent> {
    private static final Log log = LogFactory.getLog(EmbeddedAppmasterTrackService.class);
    private static final long DEFAULT_WAIT_TIME = 60000L;
    private EmbeddedServletContainer embeddedServletContainer;
    private long waitTime;

    public EmbeddedAppmasterTrackService() {
        this(60000L);
    }

    public EmbeddedAppmasterTrackService(long waitTime) {
        this.waitTime = waitTime;
    }

    public String getTrackUrl() {
        if (this.embeddedServletContainer == null) {
            log.warn((Object)"Request for track url but unable to delegate because embeddedServletContainer is not set, returning null.");
            return null;
        }
        long now = System.currentTimeMillis();
        while (now + this.waitTime > System.currentTimeMillis()) {
            int port = this.embeddedServletContainer.getPort();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Polling port from EmbeddedServletContainer port=" + port));
            }
            if (port > 0) {
                String url = "http://" + NetworkUtils.getDefaultAddress() + ":" + port;
                log.info((Object)("Giving out track url as " + url));
                return url;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        log.warn((Object)("Waited " + (System.currentTimeMillis() - now) + " millis for embeddedServletContainer port, returning null."));
        return null;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Object source = event.getSource();
        if (source instanceof AnnotationConfigEmbeddedWebApplicationContext) {
            this.embeddedServletContainer = ((AnnotationConfigEmbeddedWebApplicationContext)source).getEmbeddedServletContainer();
        }
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }
}

