/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class YarnBootClientApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Log log = LogFactory.getLog(YarnBootClientApplicationListener.class);
    private final Map<String, Object> propertySourceMap;

    public YarnBootClientApplicationListener(Map<String, Object> propertySourceMap) {
        Assert.notNull(propertySourceMap, (String)"Property source map must be set");
        this.propertySourceMap = propertySourceMap;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        MutablePropertySources propertySources = event.getEnvironment().getPropertySources();
        if (propertySources.contains("commandLineArgs")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding afterCommandLineArgs property source after commandLineArgs");
            }
            propertySources.addAfter("commandLineArgs", (PropertySource)new MapPropertySource("afterCommandLineArgs", this.propertySourceMap));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding afterCommandLineArgs property source as first");
            }
            propertySources.addFirst((PropertySource)new MapPropertySource("afterCommandLineArgs", this.propertySourceMap));
        }
    }
}

