/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.app.ClientApplicationRunner;

public abstract class AbstractClientApplication<R, T extends AbstractClientApplication<R, T>>
implements ClientApplicationRunner<R> {
    protected String applicationVersion;
    protected String applicationBaseDir;
    protected List<Object> sources = new ArrayList<Object>();
    protected List<String> profiles = new ArrayList<String>();
    protected Properties appProperties = new Properties();

    @Override
    public R run() {
        return this.run(new String[0]);
    }

    @Override
    public abstract R run(String ... var1);

    public T applicationVersion(String applicationVersion) {
        Assert.state((boolean)StringUtils.hasText((String)applicationVersion), (String)"Application version must not be empty");
        this.applicationVersion = applicationVersion;
        return this.getThis();
    }

    public T applicationBaseDir(String applicationBaseDir) {
        this.applicationBaseDir = applicationBaseDir;
        return this.getThis();
    }

    public T sources(Object ... sources) {
        if (!ObjectUtils.isEmpty((Object[])sources)) {
            this.sources.addAll(Arrays.asList(sources));
        }
        return this.getThis();
    }

    public T profiles(String ... profiles) {
        if (!ObjectUtils.isEmpty((Object[])profiles)) {
            this.profiles.addAll(Arrays.asList(profiles));
        }
        return this.getThis();
    }

    public T appProperties(Properties appProperties) {
        this.appProperties = appProperties;
        return this.getThis();
    }

    protected abstract T getThis();
}

