/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.app;

import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointMBeanExportAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.SpringApplicationCallback;
import org.springframework.yarn.boot.SpringApplicationTemplate;
import org.springframework.yarn.boot.app.AbstractClientApplication;
import org.springframework.yarn.boot.properties.SpringYarnProperties;
import org.springframework.yarn.boot.support.SpringYarnBootUtils;
import org.springframework.yarn.client.YarnClient;
import org.springframework.yarn.support.console.ApplicationsReport;

@Configuration
@EnableAutoConfiguration(exclude={EmbeddedServletContainerAutoConfiguration.class, WebMvcAutoConfiguration.class, JmxAutoConfiguration.class, BatchAutoConfiguration.class, JmxAutoConfiguration.class, EndpointMBeanExportAutoConfiguration.class, EndpointAutoConfiguration.class})
public class YarnInfoApplication
extends AbstractClientApplication<String, YarnInfoApplication> {
    @Override
    public String run() {
        return this.run(new String[0]);
    }

    @Override
    public String run(String ... args) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[0]);
        builder.web(false);
        builder.sources(new Class[]{YarnInfoApplication.class, OperationProperties.class});
        SpringYarnBootUtils.addSources(builder, this.sources.toArray(new Object[0]));
        SpringYarnBootUtils.addProfiles(builder, this.profiles.toArray(new String[0]));
        if (StringUtils.hasText((String)this.applicationBaseDir)) {
            this.appProperties.setProperty("spring.yarn.applicationDir", this.applicationBaseDir + this.applicationVersion + "/");
        }
        SpringYarnBootUtils.addApplicationListener(builder, this.appProperties);
        SpringApplicationTemplate template = new SpringApplicationTemplate(builder);
        return template.execute(new SpringApplicationCallback<String>(){

            @Override
            public String runWithSpringApplication(ApplicationContext context) throws Exception {
                OperationProperties operationProperties = (OperationProperties)context.getBean(OperationProperties.class);
                if (Operation.PUSHED == operationProperties.getOperation()) {
                    return YarnInfoApplication.this.getInstalledReport(context);
                }
                if (Operation.SUBMITTED == operationProperties.getOperation()) {
                    YarnClient client = (YarnClient)context.getBean(YarnClient.class);
                    return YarnInfoApplication.this.getSubmittedReport(client, operationProperties.isVerbose(), operationProperties.getType(), operationProperties.getHeaders());
                }
                return null;
            }
        }, args);
    }

    protected String getInstalledReport(ApplicationContext context) throws Exception {
        YarnConfiguration yarnConfiguration = (YarnConfiguration)context.getBean(YarnConfiguration.class);
        SpringYarnProperties springYarnProperties = (SpringYarnProperties)context.getBean(SpringYarnProperties.class);
        String applicationBaseDir = springYarnProperties.getApplicationBaseDir();
        Path path = new Path(applicationBaseDir);
        FileSystem fs = path.getFileSystem((org.apache.hadoop.conf.Configuration)yarnConfiguration);
        FileStatus[] listStatus = new FileStatus[]{};
        if (fs.exists(path)) {
            listStatus = fs.listStatus(path);
        }
        return ApplicationsReport.installedReportBuilder().add(ApplicationsReport.InstalledField.NAME).add(ApplicationsReport.InstalledField.PATH).from(listStatus).build().toString();
    }

    protected String getSubmittedReport(YarnClient client, boolean verbose, String type, Map<String, String> headers) {
        ApplicationsReport.SubmittedReportBuilder builder = ApplicationsReport.submittedReportBuilder();
        builder.add(new ApplicationsReport.SubmittedField[]{ApplicationsReport.SubmittedField.ID, ApplicationsReport.SubmittedField.USER, ApplicationsReport.SubmittedField.NAME, ApplicationsReport.SubmittedField.QUEUE, ApplicationsReport.SubmittedField.TYPE, ApplicationsReport.SubmittedField.STARTTIME, ApplicationsReport.SubmittedField.FINISHTIME, ApplicationsReport.SubmittedField.STATE, ApplicationsReport.SubmittedField.FINALSTATUS, ApplicationsReport.SubmittedField.ORIGTRACKURL}).sort(ApplicationsReport.SubmittedField.ID);
        if (verbose) {
            builder.from(client.listApplications(type));
        } else {
            builder.from(client.listRunningApplications(type));
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
        }
        return builder.build().toString();
    }

    @Override
    protected YarnInfoApplication getThis() {
        return this;
    }

    public static enum Operation {
        PUSHED,
        SUBMITTED;

    }

    @ConfigurationProperties(value="spring.yarn.internal.YarnInfoApplication")
    public static class OperationProperties {
        private Operation operation;
        private boolean verbose;
        private String type;
        private Map<String, String> headers;

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

