/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.app;

import java.util.HashMap;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.yarn.boot.actuate.endpoint.mvc.ContainerClusterCreateRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.ContainerClusterModifyRequest;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.ContainerClusterResource;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.YarnContainerClusterEndpointResource;
import org.springframework.yarn.boot.app.YarnContainerClusterClientException;
import org.springframework.yarn.boot.app.YarnContainerClusterOperations;

public class YarnContainerClusterTemplate
implements YarnContainerClusterOperations {
    protected final RestTemplate restTemplate;
    private final String baseUri;

    public YarnContainerClusterTemplate(String baseUri) {
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        this.baseUri = baseUri;
    }

    public YarnContainerClusterTemplate(String baseUri, RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.baseUri = baseUri;
    }

    @Override
    public YarnContainerClusterEndpointResource getClusters() throws YarnContainerClusterClientException {
        return (YarnContainerClusterEndpointResource)this.restTemplate.getForObject(this.baseUri, YarnContainerClusterEndpointResource.class, new Object[0]);
    }

    @Override
    public ContainerClusterResource clusterCreate(ContainerClusterCreateRequest request) throws YarnContainerClusterClientException {
        try {
            return (ContainerClusterResource)this.restTemplate.postForObject(this.baseUri, (Object)request, ContainerClusterResource.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public ContainerClusterResource clusterInfo(String clusterId) throws YarnContainerClusterClientException {
        try {
            return (ContainerClusterResource)this.restTemplate.getForObject(this.baseUri + "/" + clusterId, ContainerClusterResource.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public ContainerClusterResource clusterStart(String clusterId, ContainerClusterModifyRequest request) throws YarnContainerClusterClientException {
        try {
            HttpEntity requestEntity = new HttpEntity((Object)request);
            ResponseEntity exchange = this.restTemplate.exchange(this.baseUri + "/" + clusterId, HttpMethod.PUT, requestEntity, ContainerClusterResource.class, new Object[0]);
            return (ContainerClusterResource)exchange.getBody();
        }
        catch (RestClientException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public ContainerClusterResource clusterStop(String clusterId, ContainerClusterModifyRequest request) throws YarnContainerClusterClientException {
        try {
            HttpEntity requestEntity = new HttpEntity((Object)request);
            ResponseEntity exchange = this.restTemplate.exchange(this.baseUri + "/" + clusterId, HttpMethod.PUT, requestEntity, ContainerClusterResource.class, new Object[0]);
            return (ContainerClusterResource)exchange.getBody();
        }
        catch (RestClientException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public ContainerClusterResource clusterModify(String clusterId, ContainerClusterCreateRequest request) throws YarnContainerClusterClientException {
        try {
            HttpEntity requestEntity = new HttpEntity((Object)request);
            ResponseEntity exchange = this.restTemplate.exchange(this.baseUri + "/" + clusterId, HttpMethod.PATCH, requestEntity, ContainerClusterResource.class, new Object[0]);
            return (ContainerClusterResource)exchange.getBody();
        }
        catch (RestClientException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public void clusterDestroy(String clusterId) throws YarnContainerClusterClientException {
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("clusterId", clusterId);
            this.restTemplate.delete(this.baseUri + "/{clusterId}", uriVariables);
        }
        catch (RestClientException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    private YarnContainerClusterClientException convertException(Exception e) {
        return new YarnContainerClusterClientException("Error communicating with rest endpoint", e);
    }
}

