/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.util.StringUtils;
import org.springframework.yarn.client.YarnClient;

public class ClientLauncherRunner
implements CommandLineRunner {
    private static final Log log = LogFactory.getLog(ClientLauncherRunner.class);
    public static final String ACTION_SUBMIT = "submit";
    @Autowired(required=false)
    private YarnClient yarnClient;
    private String action;

    public ClientLauncherRunner() {
    }

    public ClientLauncherRunner(String action) {
        this.action = action;
    }

    public void run(String ... args) throws Exception {
        if (!StringUtils.hasText((String)this.action)) {
            return;
        }
        if (this.yarnClient == null) {
            log.warn((Object)("We have action=" + this.action + " but no yarnClient"));
            return;
        }
        log.info((Object)("Running action=" + this.action));
        if (ACTION_SUBMIT.equals(this.action)) {
            log.info((Object)"Submitting application");
            this.yarnClient.submitApplication();
        } else {
            log.warn((Object)("Unable to do startup with unknown action=" + this.action));
        }
    }

    public void setAction(String action) {
        this.action = action;
    }
}

