/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.yarn.launch.ExitCodeMapper;
import org.springframework.yarn.launch.JvmSystemExiter;
import org.springframework.yarn.launch.SimpleJvmExitCodeMapper;
import org.springframework.yarn.launch.SystemExiter;

public abstract class CommandLineRunnerSupport
implements Ordered {
    private static final Log log = LogFactory.getLog(CommandLineRunnerSupport.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean waitLatch = true;
    private int order = Integer.MIN_VALUE;
    private static SystemExiter systemExiter = new JvmSystemExiter();
    private ExitCodeMapper exitCodeMapper = new SimpleJvmExitCodeMapper();

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void exit(int status) {
        log.info((Object)("About to exit using code= " + status));
        systemExiter.exit(status);
    }

    public void exit(String status) {
        this.exit(this.exitCodeMapper.intValue(status));
    }

    public void setWaitLatch(boolean waitLatch) {
        this.waitLatch = waitLatch;
    }

    public boolean isWaitLatch() {
        return this.waitLatch;
    }

    public void setExitCodeMapper(ExitCodeMapper exitCodeMapper) {
        this.exitCodeMapper = exitCodeMapper;
    }

    public ExitCodeMapper getExitCodeMapper() {
        return this.exitCodeMapper;
    }

    protected void countDownLatch() {
        if (this.isWaitLatch()) {
            this.latch.countDown();
        }
    }

    protected void waitLatch() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            log.info((Object)"CommandLineRunner wait latch interrupted");
        }
    }

    protected void waitLatch(long timeout, TimeUnit unit) {
        try {
            this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            log.info((Object)"CommandLineRunner wait latch interrupted");
        }
    }
}

