/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.test.support;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.yarn.test.context.YarnCluster;
import org.springframework.yarn.test.support.ClusterInfo;
import org.springframework.yarn.test.support.YarnClusterManager;

public class ClusterDelegatingFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<YarnCluster> {
    private YarnCluster cluster;
    private String id = "default";
    private int nodes = 1;

    public YarnCluster getObject() throws Exception {
        return this.cluster;
    }

    public Class<YarnCluster> getObjectType() {
        return YarnCluster.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.cluster = YarnClusterManager.getInstance(true).getCluster(new ClusterInfo(this.id, this.nodes, this.nodes));
    }

    public void destroy() throws Exception {
        if (this.cluster != null) {
            YarnClusterManager.getInstance().closeCluster(this.cluster);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNodes(int nodes) {
        this.nodes = nodes;
    }
}

