/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.test.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.yarn.test.context.YarnCluster;

public abstract class ContainerLogUtils {
    static Log log = LogFactory.getLog(ContainerLogUtils.class);

    public static List<Resource> queryContainerLogs(YarnCluster yarnCluster, ApplicationId applicationId, String fileName) throws IOException {
        String lastPart = StringUtils.hasText((String)fileName) ? fileName : "*";
        String pattern = "file:" + yarnCluster.getYarnWorkDir().getAbsolutePath() + "/*logDir*/" + applicationId.toString() + "/**/" + lastPart;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> ret = new ArrayList<Resource>();
        for (Resource r : resolver.getResources(pattern)) {
            if (!r.getFile().isFile()) continue;
            ret.add(r);
        }
        return ret;
    }

    public static List<Resource> queryContainerLogs(YarnCluster yarnCluster, ApplicationId applicationId) throws IOException {
        return ContainerLogUtils.queryContainerLogs(yarnCluster, applicationId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) throws Exception {
        Scanner scanner = null;
        String content = null;
        Exception reThrow = null;
        if (file != null && file.length() > 0L) {
            try {
                scanner = new Scanner(file);
                content = scanner.useDelimiter("\\A").next();
            }
            catch (Exception e) {
                reThrow = e;
            }
            finally {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else if (file != null && file.length() == 0L) {
            content = "";
        }
        if (reThrow != null) {
            throw reThrow;
        }
        return content;
    }
}

