/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.flex.config.xml.ParsingUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class RemotingDestinationExporterBeanDefinitionFactory {
    protected static final String REMOTING_DESTINATION_EXPORTER_CLASS_NAME = "org.springframework.flex.remoting.RemotingDestinationExporter";
    private static final String MESSAGE_BROKER_ATTR = "message-broker";
    private static final String DESTINATION_ID_ATTR = "destination-id";
    private static final String CHANNELS_ATTR = "channels";
    private static final String INCLUDE_METHODS_ATTR = "include-methods";
    private static final String EXCLUDE_METHODS_ATTR = "exclude-methods";
    private static final String SERVICE_ADAPTER_ATTR = "service-adapter";
    protected static final String REF_ATTR = "ref";
    private static final String MESSAGE_BROKER_PROPERTY = "messageBroker";
    private static final String SERVICE_PROPERTY = "service";
    private static final String DESTINATION_ID_PROPERTY = "destinationId";

    RemotingDestinationExporterBeanDefinitionFactory() {
    }

    protected BeanDefinitionHolder parseInternal(Element element, ParserContext parserContext, String exportedBeanReference) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)REMOTING_DESTINATION_EXPORTER_CLASS_NAME);
        builder.getRawBeanDefinition().setRole(2);
        this.validateRemotingDestination(element, parserContext);
        String destinationId = element.getAttribute(DESTINATION_ID_ATTR);
        String brokerId = element.getAttribute(MESSAGE_BROKER_ATTR);
        builder.addPropertyReference(SERVICE_PROPERTY, exportedBeanReference);
        destinationId = StringUtils.hasText((String)destinationId) ? destinationId : exportedBeanReference;
        builder.addPropertyValue(DESTINATION_ID_PROPERTY, (Object)destinationId);
        brokerId = StringUtils.hasText((String)brokerId) ? brokerId : "_messageBroker";
        builder.addPropertyReference(MESSAGE_BROKER_PROPERTY, brokerId);
        ParsingUtils.mapOptionalAttributes(element, parserContext, builder, CHANNELS_ATTR, INCLUDE_METHODS_ATTR, EXCLUDE_METHODS_ATTR, SERVICE_ADAPTER_ATTR);
        String beanName = ParsingUtils.registerInfrastructureComponent(element, parserContext, builder);
        return new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), beanName);
    }

    protected abstract void validateRemotingDestination(Element var1, ParserContext var2);
}

