/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.messaging.jms;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.services.MessageService;
import flex.messaging.services.messaging.adapters.MessagingAdapter;
import java.util.HashSet;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.flex.messaging.jms.FlexMessageConverter;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class JmsAdapter
extends MessagingAdapter
implements InitializingBean,
BeanNameAware {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile ConnectionFactory connectionFactory;
    private volatile Object destination;
    private volatile boolean pubSubDomain;
    private volatile MessageConverter messageConverter;
    private final JmsTemplate jmsTemplate = new JmsTemplate();
    private final DefaultMessageListenerContainer messageListenerContainer = new DefaultMessageListenerContainer();
    private final Set<Object> subscriberIds = new HashSet<Object>();

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.connectionFactory, (String)"connectionFactory is required");
        Assert.notNull((Object)this.destination, (String)"destination or destination name is required");
        this.jmsTemplate.setConnectionFactory(this.connectionFactory);
        MessageConverter converterToSet = this.messageConverter;
        if (converterToSet == null || !(converterToSet instanceof FlexMessageConverter)) {
            converterToSet = new FlexMessageConverter(converterToSet);
        }
        this.jmsTemplate.setMessageConverter(converterToSet);
        MessageListenerAdapter messageListenerAdapter = new MessageListenerAdapter();
        messageListenerAdapter.setMessageConverter(converterToSet);
        messageListenerAdapter.setDelegate((Object)this);
        this.messageListenerContainer.setConnectionFactory(this.connectionFactory);
        this.messageListenerContainer.setMessageListener((Object)messageListenerAdapter);
        this.messageListenerContainer.setAutoStartup(false);
        if (this.destination instanceof Destination) {
            this.jmsTemplate.setDefaultDestination((Destination)this.destination);
            this.messageListenerContainer.setDestination((Destination)this.destination);
        } else {
            this.jmsTemplate.setPubSubDomain(this.pubSubDomain);
            this.jmsTemplate.setDefaultDestinationName((String)this.destination);
            this.messageListenerContainer.setPubSubDomain(this.pubSubDomain);
            this.messageListenerContainer.setDestinationName((String)this.destination);
        }
        this.jmsTemplate.afterPropertiesSet();
        this.messageListenerContainer.afterPropertiesSet();
    }

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public boolean handlesSubscriptions() {
        return true;
    }

    public Object invoke(Message flexMessage) {
        this.jmsTemplate.convertAndSend((Object)flexMessage);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object manage(CommandMessage commandMessage) {
        String clientId = (String)commandMessage.getClientId();
        if (commandMessage.getOperation() == 0) {
            this.subscriberIds.add(clientId);
            DefaultMessageListenerContainer defaultMessageListenerContainer = this.messageListenerContainer;
            synchronized (defaultMessageListenerContainer) {
                if (!this.messageListenerContainer.isRunning()) {
                    this.messageListenerContainer.start();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("client [" + clientId + "] subscribed to destination [" + this.getDestination().getId() + "]"));
            }
        } else if (commandMessage.getOperation() == 1) {
            this.subscriberIds.remove(clientId);
            DefaultMessageListenerContainer defaultMessageListenerContainer = this.messageListenerContainer;
            synchronized (defaultMessageListenerContainer) {
                if (this.subscriberIds.isEmpty() && this.messageListenerContainer.isRunning()) {
                    this.messageListenerContainer.stop();
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("client [" + clientId + "] unsubscribed from destination [" + this.getDestination().getId() + "]"));
            }
        }
        return null;
    }

    public void setBeanName(String beanName) {
        this.setId(beanName);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull((Object)destinationResolver, (String)"destinationResolver must not be null");
        this.jmsTemplate.setDestinationResolver(destinationResolver);
        this.messageListenerContainer.setDestinationResolver(destinationResolver);
    }

    public void setJmsDestination(Destination destination) {
        this.destination = destination;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setQueueName(String queueName) {
        this.destination = queueName;
    }

    public void setTopicName(String topicName) {
        this.pubSubDomain = true;
        this.destination = topicName;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        Assert.notNull((Object)transactionManager, (String)"transactionManager must not be null");
        this.messageListenerContainer.setTransactionManager(transactionManager);
    }

    public void start() {
        super.start();
    }

    void handleMessage(Message flexMessage) {
        flexMessage.setDestination(this.getDestination().getId());
        MessageService messageService = (MessageService)this.getDestination().getService();
        messageService.pushMessageToClients(flexMessage, true);
        messageService.sendPushMessageFromPeer(flexMessage, true);
    }
}

