/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.messaging.messages.Message;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.flex.core.MessageInterceptor;
import org.springframework.flex.core.MessageProcessingContext;
import org.springframework.flex.core.ResourceHandlingMessageInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageInterceptionAdvice
implements MethodInterceptor {
    private Set<MessageInterceptor> messageInterceptors = new HashSet<MessageInterceptor>();

    public Set<MessageInterceptor> getMessageInterceptors() {
        return this.messageInterceptors;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        MessageProcessingContext context = new MessageProcessingContext(mi.getThis());
        Message inputMessage = (Message)mi.getArguments()[0];
        Stack<ResourceHandlingMessageInterceptor> resourceHandlerStack = new Stack<ResourceHandlingMessageInterceptor>();
        for (MessageInterceptor interceptor : this.messageInterceptors) {
            if (interceptor instanceof ResourceHandlingMessageInterceptor) {
                resourceHandlerStack.add((ResourceHandlingMessageInterceptor)interceptor);
            }
            inputMessage = interceptor.preProcess(context, inputMessage);
        }
        mi.getArguments()[0] = inputMessage;
        Message outputMessage = null;
        try {
            outputMessage = (Message)mi.proceed();
        }
        catch (Exception ex) {
            this.doAfterComplete(resourceHandlerStack, context, inputMessage, outputMessage, ex);
            throw ex;
        }
        if (outputMessage != null) {
            Stack<MessageInterceptor> postProcessStack = new Stack<MessageInterceptor>();
            postProcessStack.addAll(this.messageInterceptors);
            while (!postProcessStack.empty()) {
                MessageInterceptor interceptor = (MessageInterceptor)postProcessStack.pop();
                outputMessage = interceptor.postProcess(context, inputMessage, outputMessage);
            }
        }
        this.doAfterComplete(resourceHandlerStack, context, inputMessage, outputMessage, null);
        return outputMessage;
    }

    public void setMessageInterceptors(Set<MessageInterceptor> messageInterceptors) {
        this.messageInterceptors = messageInterceptors;
    }

    private void doAfterComplete(Stack<ResourceHandlingMessageInterceptor> resourceHandlerStack, MessageProcessingContext context, Message inputMessage, Message outputMessage, Exception ex) {
        while (!resourceHandlerStack.empty()) {
            resourceHandlerStack.pop().afterCompletion(context, inputMessage, outputMessage, ex);
        }
    }
}

