/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.flex.config.RemotingDestinationMetadata;
import org.springframework.flex.remoting.RemotingDestination;
import org.springframework.flex.remoting.RemotingDestinationExporter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingAnnotationPostProcessor
implements BeanFactoryPostProcessor {
    private static final Log log = LogFactory.getLog(RemotingAnnotationPostProcessor.class);
    private static final String MESSAGE_BROKER_PROPERTY = "messageBroker";
    private static final String SERVICE_PROPERTY = "service";
    private static final String DESTINATION_ID_PROPERTY = "destinationId";
    private static final String CHANNELS_PROPERTY = "channels";
    private static final String INCLUDE_METHODS_PROPERTY = "includeMethods";
    private static final String EXCLUDE_METHODS_PROPERTY = "excludeMethods";
    private static final String SERVICE_ADAPTER_PROPERTY = "serviceAdapter";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Set<RemotingDestinationMetadata> remoteBeans = this.findRemotingDestinations(beanFactory);
        if (remoteBeans.size() > 0) {
            Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)beanFactory, (String)"In order for services to be exported via the @RemotingDestination annotation, the current BeanFactory must be a BeanDefinitionRegistry.");
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (RemotingDestinationMetadata remotingDestinationConfig : remoteBeans) {
            BeanDefinitionBuilder exporterBuilder = BeanDefinitionBuilder.rootBeanDefinition(RemotingDestinationExporter.class);
            exporterBuilder.getRawBeanDefinition().setRole(2);
            RemotingDestination remotingDestination = remotingDestinationConfig.getRemotingDestination();
            String messageBrokerId = StringUtils.hasText((String)remotingDestination.messageBroker()) ? remotingDestination.messageBroker() : "_messageBroker";
            String destinationId = StringUtils.hasText((String)remotingDestination.value()) ? remotingDestination.value() : remotingDestinationConfig.getBeanName();
            exporterBuilder.addPropertyReference(MESSAGE_BROKER_PROPERTY, messageBrokerId);
            exporterBuilder.addPropertyValue(SERVICE_PROPERTY, (Object)remotingDestinationConfig.getBeanName());
            exporterBuilder.addDependsOn(remotingDestinationConfig.getBeanName());
            exporterBuilder.addPropertyValue(DESTINATION_ID_PROPERTY, (Object)destinationId);
            exporterBuilder.addPropertyValue(CHANNELS_PROPERTY, (Object)remotingDestination.channels());
            exporterBuilder.addPropertyValue(INCLUDE_METHODS_PROPERTY, (Object)remotingDestinationConfig.getIncludeMethods());
            exporterBuilder.addPropertyValue(EXCLUDE_METHODS_PROPERTY, (Object)remotingDestinationConfig.getExcludeMethods());
            exporterBuilder.addPropertyValue(SERVICE_ADAPTER_PROPERTY, (Object)remotingDestination.serviceAdapter());
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)exporterBuilder.getBeanDefinition(), (BeanDefinitionRegistry)registry);
        }
    }

    private Set<RemotingDestinationMetadata> findRemotingDestinations(ConfigurableListableBeanFactory beanFactory) {
        HashSet<RemotingDestinationMetadata> remotingDestinations = new HashSet<RemotingDestinationMetadata>();
        HashSet beanNames = new HashSet();
        beanNames.addAll(Arrays.asList(beanFactory.getBeanDefinitionNames()));
        if (beanFactory.getParentBeanFactory() instanceof ListableBeanFactory) {
            beanNames.addAll(Arrays.asList(((ListableBeanFactory)beanFactory.getParentBeanFactory()).getBeanDefinitionNames()));
        }
        for (String beanName : beanNames) {
            Class beanClass;
            AbstractBeanDefinition abd;
            if (beanName.startsWith("scopedTarget.")) continue;
            RemotingDestination remotingDestination = null;
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(beanName);
            if (bd.isAbstract() || bd.isLazyInit()) continue;
            if (bd instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass() && (remotingDestination = (RemotingDestination)AnnotationUtils.findAnnotation((Class)(beanClass = abd.getBeanClass()), RemotingDestination.class)) != null) {
                remotingDestinations.add(new RemotingDestinationMetadata(remotingDestination, beanName, beanClass));
                continue;
            }
            Class handlerType = beanFactory.getType(beanName);
            if (handlerType != null) {
                remotingDestination = (RemotingDestination)AnnotationUtils.findAnnotation((Class)handlerType, RemotingDestination.class);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Could not get type of bean '" + beanName + "' from bean factory."));
            }
            if (remotingDestination == null) continue;
            remotingDestinations.add(new RemotingDestinationMetadata(remotingDestination, beanName, handlerType));
        }
        return remotingDestinations;
    }
}

