/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.Argument;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ArgumentMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final GraphQlArgumentBinder argumentBinder;

    public ArgumentMethodArgumentResolver(GraphQlArgumentBinder argumentBinder) {
        Assert.notNull((Object)argumentBinder, (String)"GraphQlArgumentBinder is required");
        this.argumentBinder = argumentBinder;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterAnnotation(Argument.class) != null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) throws Exception {
        String name = ArgumentMethodArgumentResolver.getArgumentName(parameter);
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)parameter);
        return this.argumentBinder.bind(environment, name, resolvableType);
    }

    static String getArgumentName(MethodParameter parameter) {
        Argument annotation = (Argument)parameter.getParameterAnnotation(Argument.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"Expected @Argument annotation");
        if (StringUtils.hasText((String)annotation.name())) {
            return annotation.name();
        }
        String parameterName = parameter.getParameterName();
        if (parameterName != null) {
            return parameterName;
        }
        throw new IllegalArgumentException("Name for argument of type [" + parameter.getNestedParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
    }
}

