/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.graphql.data.pagination.Subrange;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SubrangeMethodArgumentResolver<P>
implements HandlerMethodArgumentResolver {
    private final CursorStrategy<P> cursorStrategy;

    public SubrangeMethodArgumentResolver(CursorStrategy<P> cursorStrategy) {
        Assert.notNull(cursorStrategy, (String)"CursorStrategy is required");
        this.cursorStrategy = cursorStrategy;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(Subrange.class) && this.cursorStrategy.supports(parameter.nested().getNestedParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) throws Exception {
        boolean forward = !environment.getArguments().containsKey("last");
        Integer count = (Integer)environment.getArgument(forward ? "first" : "last");
        String cursor = (String)environment.getArgument(forward ? "after" : "before");
        P position = cursor != null ? (P)this.cursorStrategy.fromCursor(cursor) : null;
        return this.createSubrange(position, count, forward);
    }

    protected Subrange<P> createSubrange(@Nullable P pos, @Nullable Integer size, boolean forward) {
        return new Subrange<P>(pos, size, forward);
    }
}

