/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.client.DefaultClientGraphQlResponse;
import org.springframework.graphql.client.DefaultGraphQlClient;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.GraphQlClientInterceptor;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.support.CachingDocumentSource;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.graphql.support.ResourceDocumentSource;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractGraphQlClientBuilder<B extends AbstractGraphQlClientBuilder<B>>
implements GraphQlClient.Builder<B> {
    protected static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AbstractGraphQlClientBuilder.class.getClassLoader());
    private final List<GraphQlClientInterceptor> interceptors = new ArrayList<GraphQlClientInterceptor>();
    private DocumentSource documentSource = AbstractGraphQlClientBuilder.initDocumentSource();
    @Nullable
    private Encoder<?> jsonEncoder;
    @Nullable
    private Decoder<?> jsonDecoder;

    protected AbstractGraphQlClientBuilder() {
    }

    private static DocumentSource initDocumentSource() {
        return new CachingDocumentSource(new ResourceDocumentSource(Collections.singletonList(new ClassPathResource("graphql-documents/")), ResourceDocumentSource.FILE_EXTENSIONS));
    }

    @Override
    public B interceptor(GraphQlClientInterceptor ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return (B)this.self();
    }

    @Override
    public B interceptors(Consumer<List<GraphQlClientInterceptor>> interceptorsConsumer) {
        interceptorsConsumer.accept(this.interceptors);
        return (B)this.self();
    }

    @Override
    public B documentSource(DocumentSource contentLoader) {
        this.documentSource = contentLoader;
        return (B)this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    protected void setJsonCodecs(Encoder<?> encoder, Decoder<?> decoder) {
        this.jsonEncoder = encoder;
        this.jsonDecoder = decoder;
    }

    protected void setJsonEncoder(Encoder<?> encoder) {
        this.jsonEncoder = encoder;
    }

    protected Encoder<?> getJsonEncoder() {
        Assert.notNull(this.jsonEncoder, (String)"JSON Encoder not set");
        return this.jsonEncoder;
    }

    protected void setJsonDecoder(Decoder<?> decoder) {
        this.jsonDecoder = decoder;
    }

    protected Decoder<?> getJsonDecoder() {
        Assert.notNull(this.jsonDecoder, (String)"JSON Encoder not set");
        return this.jsonDecoder;
    }

    protected List<GraphQlClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    protected GraphQlClient buildGraphQlClient(GraphQlTransport transport) {
        if (jackson2Present) {
            this.jsonEncoder = this.jsonEncoder == null ? DefaultJackson2Codecs.encoder() : this.jsonEncoder;
            this.jsonDecoder = this.jsonDecoder == null ? DefaultJackson2Codecs.decoder() : this.jsonDecoder;
        }
        return new DefaultGraphQlClient(this.documentSource, this.createExecuteChain(transport), this.createExecuteSubscriptionChain(transport));
    }

    protected Consumer<AbstractGraphQlClientBuilder<?>> getBuilderInitializer() {
        return builder -> {
            builder.interceptors((T interceptorList) -> interceptorList.addAll(this.interceptors));
            builder.documentSource(this.documentSource);
            builder.setJsonCodecs(this.getEncoder(), this.getDecoder());
        };
    }

    private GraphQlClientInterceptor.Chain createExecuteChain(GraphQlTransport transport) {
        GraphQlClientInterceptor.Chain chain = request -> transport.execute(request).map(response -> new DefaultClientGraphQlResponse(request, (GraphQlResponse)response, this.getEncoder(), this.getDecoder()));
        return this.interceptors.stream().reduce(GraphQlClientInterceptor::andThen).map(interceptor -> request -> interceptor.intercept(request, chain)).orElse(chain);
    }

    private GraphQlClientInterceptor.SubscriptionChain createExecuteSubscriptionChain(GraphQlTransport transport) {
        GraphQlClientInterceptor.SubscriptionChain chain = request -> transport.executeSubscription(request).map(response -> new DefaultClientGraphQlResponse(request, (GraphQlResponse)response, this.getEncoder(), this.getDecoder()));
        return this.interceptors.stream().reduce(GraphQlClientInterceptor::andThen).map(interceptor -> request -> interceptor.interceptSubscription(request, chain)).orElse(chain);
    }

    private Encoder<?> getEncoder() {
        Assert.notNull(this.jsonEncoder, (String)"jsonEncoder has not been set");
        return this.jsonEncoder;
    }

    private Decoder<?> getDecoder() {
        Assert.notNull(this.jsonDecoder, (String)"jsonDecoder has not been set");
        return this.jsonDecoder;
    }

    protected static class DefaultJackson2Codecs {
        protected DefaultJackson2Codecs() {
        }

        static Encoder<?> encoder() {
            return new Jackson2JsonEncoder();
        }

        static Decoder<?> decoder() {
            return new Jackson2JsonDecoder();
        }
    }
}

