/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@XmlRootElement(name="errors")
public class VndErrors
implements Iterable<VndError> {
    @XmlElement(name="error")
    private final List<VndError> vndErrors;

    public VndErrors(String logref, String message, Link ... links) {
        this(new VndError(logref, message, links), new VndError[0]);
    }

    public VndErrors(VndError error, VndError ... errors) {
        Assert.notNull((Object)error, (String)"Error must not be null");
        this.vndErrors = new ArrayList<VndError>(errors.length + 1);
        this.vndErrors.add(error);
        this.vndErrors.addAll(Arrays.asList(errors));
    }

    @JsonCreator
    public VndErrors(List<VndError> errors) {
        Assert.notNull(errors, (String)"Errors must not be null!");
        Assert.isTrue((!errors.isEmpty() ? 1 : 0) != 0, (String)"Errors must not be empty!");
        this.vndErrors = errors;
    }

    protected VndErrors() {
        this.vndErrors = new ArrayList<VndError>();
    }

    public VndErrors add(VndError error) {
        this.vndErrors.add(error);
        return this;
    }

    @JsonValue
    private List<VndError> getErrors() {
        return this.vndErrors;
    }

    @Override
    public Iterator<VndError> iterator() {
        return this.vndErrors.iterator();
    }

    public String toString() {
        return String.format("VndErrors[%s]", StringUtils.collectionToCommaDelimitedString(this.vndErrors));
    }

    public int hashCode() {
        return ((Object)this.vndErrors).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VndErrors)) {
            return false;
        }
        VndErrors that = (VndErrors)obj;
        return ((Object)this.vndErrors).equals(that.vndErrors);
    }

    @XmlType
    public static class VndError
    extends ResourceSupport {
        @XmlAttribute
        @JsonProperty
        private final String logref;
        @XmlElement
        @JsonProperty
        private final String message;

        public VndError(String logref, String message, Link ... links) {
            Assert.hasText((String)logref, (String)"Logref must not be null or empty!");
            Assert.hasText((String)message, (String)"Message must not be null or empty!");
            this.logref = logref;
            this.message = message;
            this.add(Arrays.asList(links));
        }

        protected VndError() {
            this.logref = null;
            this.message = null;
        }

        public String getLogref() {
            return this.logref;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        public String toString() {
            return String.format("VndError[logref: %s, message: %s, links: [%s]]", this.logref, this.message, StringUtils.collectionToCommaDelimitedString(this.getLinks()));
        }

        @Override
        public int hashCode() {
            int result = 17;
            result += 31 * this.logref.hashCode();
            return result += 31 * this.message.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VndError)) {
                return false;
            }
            VndError that = (VndError)obj;
            return this.logref.equals(that.logref) && this.message.equals(that.message);
        }
    }
}

