/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.LinkDiscoverer;
import org.springframework.hateoas.LinkDiscoverers;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.LinkBuilderBeanDefinitionRegistrar;
import org.springframework.hateoas.core.AnnotationRelProvider;
import org.springframework.hateoas.core.DefaultRelProvider;
import org.springframework.hateoas.core.DelegatingRelProvider;
import org.springframework.hateoas.core.EvoInflectorRelProvider;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.HalLinkDiscoverer;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.hateoas.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

class HypermediaSupportBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String DELEGATING_REL_PROVIDER_BEAN_NAME = "_relProvider";
    private static final String LINK_DISCOVERER_REGISTRY_BEAN_NAME = "_linkDiscovererRegistry";
    private static final String HAL_OBJECT_MAPPER_BEAN_NAME = "_halObjectMapper";
    private static final String MESSAGE_SOURCE_BEAN_NAME = "linkRelationMessageSource";
    private static final boolean JACKSON2_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", null);
    private static final boolean JSONPATH_PRESENT = ClassUtils.isPresent((String)"com.jayway.jsonpath.JsonPath", null);
    private static final boolean EVO_PRESENT = ClassUtils.isPresent((String)"org.atteo.evo.inflector.English", null);
    private final ImportBeanDefinitionRegistrar linkBuilderBeanDefinitionRegistrar = new LinkBuilderBeanDefinitionRegistrar();

    HypermediaSupportBeanDefinitionRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.linkBuilderBeanDefinitionRegistrar.registerBeanDefinitions(metadata, registry);
        Map attributes = metadata.getAnnotationAttributes(EnableHypermediaSupport.class.getName());
        List<EnableHypermediaSupport.HypermediaType> types = Arrays.asList((EnableHypermediaSupport.HypermediaType[])attributes.get("type"));
        for (EnableHypermediaSupport.HypermediaType type : types) {
            if (!JSONPATH_PRESENT) continue;
            AbstractBeanDefinition linkDiscovererBeanDefinition = this.getLinkDiscovererBeanDefinition(type);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)linkDiscovererBeanDefinition, BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)linkDiscovererBeanDefinition, (BeanDefinitionRegistry)registry)), (BeanDefinitionRegistry)registry);
        }
        if (types.contains((Object)EnableHypermediaSupport.HypermediaType.HAL) && JACKSON2_PRESENT) {
            BeanDefinitionBuilder halQueryMapperBuilder = BeanDefinitionBuilder.rootBeanDefinition(ObjectMapper.class);
            HypermediaSupportBeanDefinitionRegistrar.registerSourcedBeanDefinition(halQueryMapperBuilder, metadata, registry, HAL_OBJECT_MAPPER_BEAN_NAME);
            BeanDefinitionBuilder customizerBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(DefaultObjectMapperCustomizer.class);
            HypermediaSupportBeanDefinitionRegistrar.registerSourcedBeanDefinition(customizerBeanDefinition, metadata, registry);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(Jackson2ModuleRegisteringBeanPostProcessor.class);
            HypermediaSupportBeanDefinitionRegistrar.registerSourcedBeanDefinition(builder, metadata, registry);
        }
        if (!types.isEmpty()) {
            BeanDefinitionBuilder linkDiscoverersRegistryBuilder = BeanDefinitionBuilder.rootBeanDefinition(PluginRegistryFactoryBean.class);
            linkDiscoverersRegistryBuilder.addPropertyValue("type", LinkDiscoverer.class);
            HypermediaSupportBeanDefinitionRegistrar.registerSourcedBeanDefinition(linkDiscoverersRegistryBuilder, metadata, registry, LINK_DISCOVERER_REGISTRY_BEAN_NAME);
            BeanDefinitionBuilder linkDiscoverersBuilder = BeanDefinitionBuilder.rootBeanDefinition(LinkDiscoverers.class);
            linkDiscoverersBuilder.addConstructorArgReference(LINK_DISCOVERER_REGISTRY_BEAN_NAME);
            HypermediaSupportBeanDefinitionRegistrar.registerSourcedBeanDefinition(linkDiscoverersBuilder, metadata, registry);
        }
        HypermediaSupportBeanDefinitionRegistrar.registerRelProviderPluginRegistryAndDelegate(registry);
    }

    private static void registerRelProviderPluginRegistryAndDelegate(BeanDefinitionRegistry registry) {
        Class defaultRelProviderType = EVO_PRESENT ? EvoInflectorRelProvider.class : DefaultRelProvider.class;
        RootBeanDefinition defaultRelProviderBeanDefinition = new RootBeanDefinition(defaultRelProviderType);
        registry.registerBeanDefinition("defaultRelProvider", (BeanDefinition)defaultRelProviderBeanDefinition);
        RootBeanDefinition annotationRelProviderBeanDefinition = new RootBeanDefinition(AnnotationRelProvider.class);
        registry.registerBeanDefinition("annotationRelProvider", (BeanDefinition)annotationRelProviderBeanDefinition);
        BeanDefinitionBuilder registryFactoryBeanBuilder = BeanDefinitionBuilder.rootBeanDefinition(PluginRegistryFactoryBean.class);
        registryFactoryBeanBuilder.addPropertyValue("type", RelProvider.class);
        registryFactoryBeanBuilder.addPropertyValue("exclusions", DelegatingRelProvider.class);
        AbstractBeanDefinition registryBeanDefinition = registryFactoryBeanBuilder.getBeanDefinition();
        registry.registerBeanDefinition("relProviderPluginRegistry", (BeanDefinition)registryBeanDefinition);
        BeanDefinitionBuilder delegateBuilder = BeanDefinitionBuilder.rootBeanDefinition(DelegatingRelProvider.class);
        delegateBuilder.addConstructorArgValue((Object)registryBeanDefinition);
        AbstractBeanDefinition beanDefinition = delegateBuilder.getBeanDefinition();
        beanDefinition.setPrimary(true);
        registry.registerBeanDefinition(DELEGATING_REL_PROVIDER_BEAN_NAME, (BeanDefinition)beanDefinition);
    }

    private AbstractBeanDefinition getLinkDiscovererBeanDefinition(EnableHypermediaSupport.HypermediaType type) {
        RootBeanDefinition definition;
        switch (type) {
            case HAL: {
                definition = new RootBeanDefinition(HalLinkDiscoverer.class);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unsupported hypermedia type %s!", new Object[]{type}));
            }
        }
        definition.setSource((Object)this);
        return definition;
    }

    private static String registerSourcedBeanDefinition(BeanDefinitionBuilder builder, AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        String generateBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
        return HypermediaSupportBeanDefinitionRegistrar.registerSourcedBeanDefinition(builder, metadata, registry, generateBeanName);
    }

    private static String registerSourcedBeanDefinition(BeanDefinitionBuilder builder, AnnotationMetadata metadata, BeanDefinitionRegistry registry, String name) {
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        beanDefinition.setSource((Object)metadata);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, name);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        return name;
    }

    private static class DefaultObjectMapperCustomizer
    implements BeanPostProcessor {
        private DefaultObjectMapperCustomizer() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (!HypermediaSupportBeanDefinitionRegistrar.HAL_OBJECT_MAPPER_BEAN_NAME.equals(beanName)) {
                return bean;
            }
            ObjectMapper mapper = (ObjectMapper)bean;
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return mapper;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }

    static class Jackson2ModuleRegisteringBeanPostProcessor
    implements BeanPostProcessor,
    BeanFactoryAware {
        private AutowireCapableBeanFactory beanFactory;

        Jackson2ModuleRegisteringBeanPostProcessor() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            Assert.isInstanceOf(AutowireCapableBeanFactory.class, (Object)beanFactory, (String)"BeanFactory must be an AutowireCapableBeanFactory!");
            this.beanFactory = (AutowireCapableBeanFactory)beanFactory;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            RequestMappingHandlerAdapter adapter;
            if (bean instanceof RequestMappingHandlerAdapter) {
                adapter = (RequestMappingHandlerAdapter)bean;
                adapter.setMessageConverters(this.potentiallyRegisterModule(adapter.getMessageConverters()));
            }
            if (bean instanceof RequestMappingHandlerAdapter) {
                adapter = (RequestMappingHandlerAdapter)bean;
                adapter.setMessageConverters(this.potentiallyRegisterModule(adapter.getMessageConverters()));
            }
            if (bean instanceof RestTemplate) {
                RestTemplate template = (RestTemplate)bean;
                template.setMessageConverters(this.potentiallyRegisterModule(template.getMessageConverters()));
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        private List<HttpMessageConverter<?>> potentiallyRegisterModule(List<HttpMessageConverter<?>> converters) {
            for (HttpMessageConverter<?> converter : converters) {
                MappingJackson2HttpMessageConverter halConverterCandidate;
                ObjectMapper objectMapper;
                if (!(converter instanceof MappingJackson2HttpMessageConverter) || !Jackson2HalModule.isAlreadyRegisteredIn(objectMapper = (halConverterCandidate = (MappingJackson2HttpMessageConverter)converter).getObjectMapper())) continue;
                return converters;
            }
            CurieProvider curieProvider = Jackson2ModuleRegisteringBeanPostProcessor.getCurieProvider((BeanFactory)this.beanFactory);
            RelProvider relProvider = (RelProvider)this.beanFactory.getBean(HypermediaSupportBeanDefinitionRegistrar.DELEGATING_REL_PROVIDER_BEAN_NAME, RelProvider.class);
            ObjectMapper halObjectMapper = (ObjectMapper)this.beanFactory.getBean(HypermediaSupportBeanDefinitionRegistrar.HAL_OBJECT_MAPPER_BEAN_NAME, ObjectMapper.class);
            MessageSourceAccessor linkRelationMessageSource = (MessageSourceAccessor)this.beanFactory.getBean(HypermediaSupportBeanDefinitionRegistrar.MESSAGE_SOURCE_BEAN_NAME, MessageSourceAccessor.class);
            halObjectMapper.registerModule((Module)new Jackson2HalModule());
            halObjectMapper.setHandlerInstantiator((HandlerInstantiator)new Jackson2HalModule.HalHandlerInstantiator(relProvider, curieProvider, linkRelationMessageSource, this.beanFactory));
            TypeConstrainedMappingJackson2HttpMessageConverter halConverter = new TypeConstrainedMappingJackson2HttpMessageConverter(ResourceSupport.class);
            halConverter.setSupportedMediaTypes(Arrays.asList(MediaTypes.HAL_JSON));
            halConverter.setObjectMapper(halObjectMapper);
            ArrayList result = new ArrayList(converters.size());
            result.add((HttpMessageConverter<?>)halConverter);
            result.addAll(converters);
            return result;
        }

        private static CurieProvider getCurieProvider(BeanFactory factory) {
            try {
                return (CurieProvider)factory.getBean(CurieProvider.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }
    }
}

