/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class DummyInvocationUtils {
    private static final ObjenesisStd OBJENESIS = new ObjenesisStd();
    private static final Map<Class<?>, Class<?>> CLASS_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    public static <T> T methodOn(Class<T> type, Object ... parameters) {
        Assert.notNull(type, (String)"Given type must not be null!");
        InvocationRecordingMethodInterceptor interceptor = new InvocationRecordingMethodInterceptor(type, parameters);
        return DummyInvocationUtils.getProxyWithInterceptor(type, interceptor, type.getClassLoader());
    }

    private static <T> T getProxyWithInterceptor(Class<?> type, InvocationRecordingMethodInterceptor interceptor, ClassLoader classLoader) {
        if (type.isInterface()) {
            ProxyFactory factory = new ProxyFactory((Object)EmptyTargetSource.INSTANCE);
            factory.addInterface(type);
            factory.addInterface(LastInvocationAware.class);
            factory.addAdvice((Advice)interceptor);
            return (T)factory.getProxy();
        }
        Factory factory = (Factory)OBJENESIS.newInstance(DummyInvocationUtils.getOrCreateEnhancedClass(type, classLoader));
        factory.setCallbacks(new Callback[]{interceptor});
        return (T)factory;
    }

    private static Class<?> getOrCreateEnhancedClass(Class<?> type, ClassLoader classLoader) {
        Assert.notNull(type, (String)"Source type must not be null!");
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null!");
        Class result = CLASS_CACHE.get(type);
        if (result != null) {
            return result;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setInterfaces(new Class[]{LastInvocationAware.class});
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setClassLoader(classLoader);
        result = enhancer.createClass();
        CLASS_CACHE.put(type, result);
        return result;
    }

    static final class SimpleMethodInvocation
    implements MethodInvocation {
        @NonNull
        private final Class<?> targetType;
        @NonNull
        private final Method method;
        @NonNull
        private final Object[] arguments;

        public SimpleMethodInvocation(@NonNull Class<?> targetType, @NonNull Method method, @NonNull Object[] arguments) {
            if (targetType == null) {
                throw new NullPointerException("targetType is marked @NonNull but is null");
            }
            if (method == null) {
                throw new NullPointerException("method is marked @NonNull but is null");
            }
            if (arguments == null) {
                throw new NullPointerException("arguments is marked @NonNull but is null");
            }
            this.targetType = targetType;
            this.method = method;
            this.arguments = arguments;
        }

        @Override
        @NonNull
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Override
        @NonNull
        public Method getMethod() {
            return this.method;
        }

        @Override
        @NonNull
        public Object[] getArguments() {
            return this.arguments;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleMethodInvocation)) {
                return false;
            }
            SimpleMethodInvocation other = (SimpleMethodInvocation)o;
            Class<?> this$targetType = this.getTargetType();
            Class<?> other$targetType = other.getTargetType();
            if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            return Arrays.deepEquals(this.getArguments(), other.getArguments());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $targetType = this.getTargetType();
            result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArguments());
            return result;
        }

        public String toString() {
            return "DummyInvocationUtils.SimpleMethodInvocation(targetType=" + this.getTargetType() + ", method=" + this.getMethod() + ", arguments=" + Arrays.deepToString(this.getArguments()) + ")";
        }
    }

    public static interface MethodInvocation {
        public Object[] getArguments();

        public Method getMethod();

        public Class<?> getTargetType();
    }

    private static class InvocationRecordingMethodInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    LastInvocationAware,
    MethodInterceptor {
        private static final Method GET_INVOCATIONS = ReflectionUtils.findMethod(LastInvocationAware.class, (String)"getLastInvocation");
        private static final Method GET_OBJECT_PARAMETERS = ReflectionUtils.findMethod(LastInvocationAware.class, (String)"getObjectParameters");
        private final Class<?> targetType;
        private final Object[] objectParameters;
        private MethodInvocation invocation;

        InvocationRecordingMethodInterceptor(Class<?> targetType, Object ... parameters) {
            Assert.notNull(targetType, (String)"Target type must not be null!");
            Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
            this.targetType = targetType;
            this.objectParameters = (Object[])parameters.clone();
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) {
            if (GET_INVOCATIONS.equals(method)) {
                return this.getLastInvocation();
            }
            if (GET_OBJECT_PARAMETERS.equals(method)) {
                return this.getObjectParameters();
            }
            if (Object.class.equals(method.getDeclaringClass())) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)obj, (Object[])args);
            }
            this.invocation = new SimpleMethodInvocation(this.targetType, method, args);
            Class<?> returnType = method.getReturnType();
            return returnType.cast(DummyInvocationUtils.getProxyWithInterceptor(returnType, this, obj.getClass().getClassLoader()));
        }

        public Object invoke(org.aopalliance.intercept.MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        @Override
        public MethodInvocation getLastInvocation() {
            return this.invocation;
        }

        @Override
        public Iterator<Object> getObjectParameters() {
            return Arrays.asList(this.objectParameters).iterator();
        }
    }

    public static interface LastInvocationAware {
        public Iterator<Object> getObjectParameters();

        public MethodInvocation getLastInvocation();
    }
}

