/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class CachingMappingDiscoverer
implements MappingDiscoverer {
    private static final Map<String, String> CACHE = new ConcurrentReferenceHashMap();
    private final MappingDiscoverer discoverer;

    @Override
    public String getMapping(final Class<?> type) {
        String key = CachingMappingDiscoverer.key(type, null);
        return this.getMapping(key, new CachedCall(){

            @Override
            public String getMapping() {
                return CachingMappingDiscoverer.this.discoverer.getMapping(type);
            }
        });
    }

    @Override
    public String getMapping(final Method method) {
        String key = CachingMappingDiscoverer.key(method.getDeclaringClass(), method);
        return this.getMapping(key, new CachedCall(){

            @Override
            public String getMapping() {
                return CachingMappingDiscoverer.this.discoverer.getMapping(method);
            }
        });
    }

    @Override
    public String getMapping(final Class<?> type, final Method method) {
        String key = CachingMappingDiscoverer.key(type, method);
        return this.getMapping(key, new CachedCall(){

            @Override
            public String getMapping() {
                return CachingMappingDiscoverer.this.discoverer.getMapping(type, method);
            }
        });
    }

    private String getMapping(String key, CachedCall cachedCall) {
        if (CACHE.containsKey(key)) {
            return CACHE.get(key);
        }
        String mapping = cachedCall.getMapping();
        CACHE.put(key, mapping);
        return mapping;
    }

    private static String key(Class<?> type, Method method) {
        StringBuilder builder = new StringBuilder(type.getName());
        if (method == null) {
            return builder.toString();
        }
        builder.append(method.getName());
        builder.append(StringUtils.arrayToCommaDelimitedString((Object[])method.getParameterTypes()));
        return builder.toString();
    }

    private CachingMappingDiscoverer(MappingDiscoverer discoverer) {
        this.discoverer = discoverer;
    }

    public static CachingMappingDiscoverer of(MappingDiscoverer discoverer) {
        return new CachingMappingDiscoverer(discoverer);
    }

    private static interface CachedCall {
        public String getMapping();
    }
}

