/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ForwardedHeader;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

class UriComponentsBuilderFactory {
    private static final String REQUEST_ATTRIBUTES_MISSING = "Could not find current request via RequestContextHolder. Is this being called from a Spring MVC handler?";
    private static final String CACHE_KEY = ControllerLinkBuilder.class.getName() + "#BUILDER_CACHE";

    UriComponentsBuilderFactory() {
    }

    public static UriComponentsBuilder getBuilder() {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return UriComponentsBuilder.fromPath((String)"/");
        }
        URI baseUri = UriComponentsBuilderFactory.getCachedBaseUri();
        return baseUri != null ? UriComponentsBuilder.fromUri((URI)baseUri) : UriComponentsBuilderFactory.cacheBaseUri(UriComponentsBuilderFactory.createBuilderFromRequest());
    }

    private static UriComponentsBuilder createBuilderFromRequest() {
        HttpServletRequest request = UriComponentsBuilderFactory.getCurrentRequest();
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request);
        return UriComponentsBuilderFactory.isSpringAtLeast5_1() ? builder : ForwardedHeader.handleXForwardedSslHeader(request, (UriComponentsBuilder)builder);
    }

    private static boolean isSpringAtLeast5_1() {
        String versionOfSpringFramework = ApplicationContext.class.getPackage().getImplementationVersion();
        String[] parts = versionOfSpringFramework.split("\\.");
        int majorVersion = Integer.parseInt(parts[0]);
        int minorVersion = Integer.parseInt(parts[1]);
        return majorVersion >= 5 && minorVersion >= 1 || majorVersion > 5;
    }

    private static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = UriComponentsBuilderFactory.getRequestAttributes();
        HttpServletRequest servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"Could not find current HttpServletRequest");
        return servletRequest;
    }

    private static RequestAttributes getRequestAttributes() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Assert.state((requestAttributes != null ? 1 : 0) != 0, (String)REQUEST_ATTRIBUTES_MISSING);
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)requestAttributes);
        return requestAttributes;
    }

    private static UriComponentsBuilder cacheBaseUri(UriComponentsBuilder builder) {
        URI uri = builder.build().toUri();
        UriComponentsBuilderFactory.getRequestAttributes().setAttribute(CACHE_KEY, (Object)uri, 0);
        return builder;
    }

    private static URI getCachedBaseUri() {
        return (URI)UriComponentsBuilderFactory.getRequestAttributes().getAttribute(CACHE_KEY, 0);
    }
}

