/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.jaxrs;

import java.lang.annotation.Annotation;
import javax.ws.rs.Path;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.mvc.UriComponentsLinkBuilder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class JaxRsLinkBuilder
extends UriComponentsLinkBuilder<JaxRsLinkBuilder> {
    private JaxRsLinkBuilder(UriComponentsBuilder builder) {
        super(builder);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> service) {
        return JaxRsLinkBuilder.linkTo(service, new Object[0]);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> service, Object ... parameters) {
        Path annotation = (Path)AnnotationUtils.findAnnotation(service, Path.class);
        String path = (String)AnnotationUtils.getValue((Annotation)annotation);
        JaxRsLinkBuilder builder = new JaxRsLinkBuilder((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentServletMapping());
        UriTemplate template = new UriTemplate(path);
        return (JaxRsLinkBuilder)builder.slash(template.expand(parameters));
    }

    @Override
    protected JaxRsLinkBuilder getThis() {
        return this;
    }

    @Override
    protected JaxRsLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new JaxRsLinkBuilder(builder);
    }
}

