/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.util.Assert;

public abstract class ResourceAssemblerSupport<T extends Identifiable<?>, D extends ResourceSupport>
implements ResourceAssembler<T, D> {
    private final Class<?> controllerClass;
    private final Class<D> resourceType;

    public ResourceAssemblerSupport(Class<?> controllerClass, Class<D> resourceType) {
        Assert.notNull(controllerClass);
        Assert.notNull(resourceType);
        this.controllerClass = controllerClass;
        this.resourceType = resourceType;
    }

    public List<D> toResources(Iterable<? extends T> entities) {
        Assert.notNull(entities);
        ArrayList result = new ArrayList();
        for (Identifiable entity : entities) {
            result.add(this.toResource(entity));
        }
        return result;
    }

    protected D createResource(T entity) {
        return this.createResource(entity, new Object[0]);
    }

    protected D createResource(T entity, Object ... parameters) {
        return this.createResourceWithId(entity.getId(), entity, parameters);
    }

    protected D createResourceWithId(Object id, T entity) {
        return this.createResourceWithId(id, entity, new Object[0]);
    }

    protected D createResourceWithId(Object id, T entity, Object ... parameters) {
        Assert.notNull(entity);
        Assert.notNull((Object)id);
        D instance = this.instantiateResource(entity);
        ((ResourceSupport)instance).add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(this.controllerClass, this.unwrapIdentifyables(parameters)).slash(id)).withSelfRel());
        return instance;
    }

    private Object[] unwrapIdentifyables(Object[] values) {
        ArrayList<Object> result = new ArrayList<Object>(values.length);
        for (Object element : Arrays.asList(values)) {
            result.add(element instanceof Identifiable ? ((Identifiable)element).getId() : element);
        }
        return result.toArray();
    }

    protected D instantiateResource(T entity) {
        return (D)((ResourceSupport)BeanUtils.instantiateClass(this.resourceType));
    }
}

