/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.ContextualSerializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.std.ContainerSerializerBase;
import org.codehaus.jackson.map.ser.std.MapSerializer;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.hal.LinkMixin;
import org.springframework.hateoas.hal.ResourceSupportMixin;

public class Jackson1HalModule
extends SimpleModule {
    public Jackson1HalModule() {
        super("json-hal-module", new Version(1, 0, 0, null));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(ResourceSupport.class, ResourceSupportMixin.class);
    }

    public static class OptionalListSerializer
    extends ContainerSerializerBase<Object> {
        private final BeanProperty property;
        private JsonSerializer<Object> serializer;

        public OptionalListSerializer() {
            this(null);
        }

        public OptionalListSerializer(BeanProperty property) {
            super(List.class, false);
            this.property = property;
        }

        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            List list = (List)value;
            if (list.size() == 1) {
                this.serializeContents(list.iterator(), jgen, provider);
                return;
            }
            jgen.writeStartArray();
            this.serializeContents(list.iterator(), jgen, provider);
            jgen.writeEndArray();
        }

        private void serializeContents(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            while (value.hasNext()) {
                Object elem = value.next();
                if (elem == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                if (this.serializer == null) {
                    this.serializer = provider.findValueSerializer(elem.getClass(), this.property);
                }
                this.serializer.serialize(elem, jgen, provider);
            }
        }
    }

    public static class HalLinkListSerializer
    extends ContainerSerializerBase<List<Link>>
    implements ContextualSerializer<List<Link>> {
        private final BeanProperty property;

        public HalLinkListSerializer() {
            this(null);
        }

        public HalLinkListSerializer(BeanProperty property) {
            super(List.class, false);
            this.property = property;
        }

        public void serialize(List<Link> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            HashMap sortedLinks = new HashMap();
            for (Link link : value) {
                if (sortedLinks.get(link.getRel()) == null) {
                    sortedLinks.put(link.getRel(), new ArrayList());
                }
                ((List)sortedLinks.get(link.getRel())).add(link);
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.uncheckedSimpleType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Link.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct((String[])new String[0], (JavaType)mapType, (boolean)true, null, null, (JsonSerializer)provider.findKeySerializer(keyType, null), (JsonSerializer)new OptionalListSerializer(this.property));
            serializer.serialize(sortedLinks, jgen, provider);
        }

        public JsonSerializer<List<Link>> createContextual(SerializationConfig config, BeanProperty property) throws JsonMappingException {
            return new HalLinkListSerializer(property);
        }

        public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }
}

