/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class AnnotationAttribute {
    private final Class<? extends Annotation> annotationType;
    private final String attributeName;

    public AnnotationAttribute(Class<? extends Annotation> annotationType) {
        this(annotationType, null);
    }

    public AnnotationAttribute(Class<? extends Annotation> annotationType, String attributeName) {
        Assert.notNull(annotationType);
        this.annotationType = annotationType;
        this.attributeName = attributeName;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public String getValueFrom(AnnotatedElement annotatedElement) {
        Annotation annotation = annotatedElement.getAnnotation(this.annotationType);
        return (String)(this.attributeName == null ? AnnotationUtils.getValue((Annotation)annotation) : AnnotationUtils.getValue((Annotation)annotation, (String)this.attributeName));
    }

    public String getValueFrom(Annotation annotation) {
        return (String)(this.attributeName == null ? AnnotationUtils.getValue((Annotation)annotation) : AnnotationUtils.getValue((Annotation)annotation, (String)this.attributeName));
    }
}

