/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.core.ObjectUtils;
import org.springframework.hateoas.hal.LinkMixin;
import org.springframework.hateoas.hal.ResourceSupportMixin;
import org.springframework.hateoas.hal.ResourcesMixin;
import org.springframework.util.Assert;

public class Jackson2HalModule
extends SimpleModule {
    private static final long serialVersionUID = 7806951456457932384L;

    public Jackson2HalModule() {
        super("json-hal-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(ResourceSupport.class, ResourceSupportMixin.class);
        this.setMixInAnnotation(Resources.class, ResourcesMixin.class);
    }

    public static class HalHandlerInstantiator
    extends HandlerInstantiator {
        private final Map<Class<?>, Object> instanceMap = new HashMap();

        public HalHandlerInstantiator(RelProvider resolver) {
            Assert.notNull((Object)resolver, (String)"RelProvider must not be null!");
            this.instanceMap.put(HalResourcesSerializer.class, (Object)new HalResourcesSerializer(null, resolver));
        }

        private Object findInstance(Class<?> type) {
            Object result = this.instanceMap.get(type);
            return result != null ? result : BeanUtils.instantiateClass(type);
        }

        public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
            return (JsonDeserializer)this.findInstance(deserClass);
        }

        public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
            return (KeyDeserializer)this.findInstance(keyDeserClass);
        }

        public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
            return (JsonSerializer)this.findInstance(serClass);
        }

        public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
            return (TypeResolverBuilder)this.findInstance(builderClass);
        }

        public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
            return (TypeIdResolver)this.findInstance(resolverClass);
        }
    }

    public static class HalResourcesDeserializer
    extends ContainerDeserializerBase<List<Object>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 4755806754621032622L;
        private JavaType contentType;

        public HalResourcesDeserializer() {
            this(List.class, null);
        }

        public HalResourcesDeserializer(JavaType vc) {
            this(null, vc);
        }

        private HalResourcesDeserializer(Class<?> type, JavaType contentType) {
            super(type);
            this.contentType = contentType;
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Object> result = new ArrayList<Object>();
            JsonDeserializer deser = ctxt.findRootValueDeserializer(this.contentType);
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Object object;
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Expected relation name", jp.getCurrentLocation());
                }
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        object = deser.deserialize(jp, ctxt);
                        result.add(object);
                    }
                    continue;
                }
                object = deser.deserialize(jp, ctxt);
                result.add(object);
            }
            return result;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JavaType vc = property.getType().getContentType();
            HalResourcesDeserializer des = new HalResourcesDeserializer(vc);
            return des;
        }
    }

    public static class HalLinkListDeserializer
    extends ContainerDeserializerBase<List<Link>> {
        private static final long serialVersionUID = 6420432361123210955L;

        public HalLinkListDeserializer() {
            super(List.class);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Link> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Link> result = new ArrayList<Link>();
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Link link;
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Expected relation name", jp.getCurrentLocation());
                }
                String relation = jp.getText();
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        link = (Link)jp.readValueAs(Link.class);
                        result.add(new Link(link.getHref(), relation));
                    }
                    continue;
                }
                link = (Link)jp.readValueAs(Link.class);
                result.add(new Link(link.getHref(), relation));
            }
            return result;
        }
    }

    public static class OptionalListJackson2Serializer
    extends ContainerSerializer<Object>
    implements ContextualSerializer {
        private final BeanProperty property;
        private JsonSerializer<Object> serializer;

        public OptionalListJackson2Serializer() {
            this(null);
        }

        public OptionalListJackson2Serializer(BeanProperty property) {
            super(List.class, false);
            this.property = property;
        }

        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            List list = (List)value;
            if (list.size() == 1) {
                this.serializeContents(list.iterator(), jgen, provider);
                return;
            }
            jgen.writeStartArray();
            this.serializeContents(list.iterator(), jgen, provider);
            jgen.writeEndArray();
        }

        private void serializeContents(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            while (value.hasNext()) {
                Object elem = value.next();
                if (elem == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                if (this.serializer == null) {
                    this.serializer = provider.findValueSerializer(elem.getClass(), this.property);
                }
                this.serializer.serialize(elem, jgen, provider);
            }
        }

        public JsonSerializer<?> getContentSerializer() {
            return this.serializer;
        }

        public JavaType getContentType() {
            return null;
        }

        public boolean hasSingleElement(Object arg0) {
            return false;
        }

        public boolean isEmpty(Object arg0) {
            return false;
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new OptionalListJackson2Serializer(property);
        }
    }

    public static class HalResourcesSerializer
    extends ContainerSerializer<Collection<?>>
    implements ContextualSerializer {
        private static final String DEFAULT_REL = "content";
        private final BeanProperty property;
        private final RelProvider relProvider;

        public HalResourcesSerializer() {
            this(null);
        }

        public HalResourcesSerializer(RelProvider relPorvider) {
            this(null, relPorvider);
        }

        public HalResourcesSerializer(BeanProperty property, RelProvider relProvider) {
            super(Collection.class, false);
            this.property = property;
            this.relProvider = relProvider;
        }

        public void serialize(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            HashMap sortedLinks = new HashMap();
            for (Object resource : value) {
                String relation;
                Class<?> type = ObjectUtils.getResourceType(resource);
                String string = relation = this.relProvider == null ? DEFAULT_REL : this.relProvider.getSingleResourceRelFor(type);
                if (relation == null) {
                    relation = DEFAULT_REL;
                }
                if (sortedLinks.get(relation) == null) {
                    sortedLinks.put(relation, new ArrayList());
                }
                ((List)sortedLinks.get(relation)).add(resource);
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.uncheckedSimpleType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Resource.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct((String[])new String[0], (JavaType)mapType, (boolean)true, null, (JsonSerializer)provider.findKeySerializer(keyType, null), (JsonSerializer)new OptionalListJackson2Serializer(this.property));
            serializer.serialize(sortedLinks, jgen, provider);
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new HalResourcesSerializer(property, this.relProvider);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(Collection<?> value) {
            return false;
        }

        public boolean hasSingleElement(Collection<?> value) {
            return false;
        }

        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    public static class HalLinkListSerializer
    extends ContainerSerializer<List<Link>>
    implements ContextualSerializer {
        private final BeanProperty property;

        public HalLinkListSerializer() {
            this(null);
        }

        public HalLinkListSerializer(BeanProperty property) {
            super(List.class, false);
            this.property = property;
        }

        public void serialize(List<Link> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            HashMap sortedLinks = new HashMap();
            for (Link link : value) {
                if (sortedLinks.get(link.getRel()) == null) {
                    sortedLinks.put(link.getRel(), new ArrayList());
                }
                ((List)sortedLinks.get(link.getRel())).add(link);
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.uncheckedSimpleType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Link.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct((String[])new String[0], (JavaType)mapType, (boolean)true, null, (JsonSerializer)provider.findKeySerializer(keyType, null), (JsonSerializer)new OptionalListJackson2Serializer(this.property));
            serializer.serialize(sortedLinks, jgen, provider);
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new HalLinkListSerializer(property);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(List<Link> value) {
            return false;
        }

        public boolean hasSingleElement(List<Link> value) {
            return false;
        }

        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }
}

