/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsProperty;
import org.springframework.http.HttpMethod;

class HalFormsAffordanceModel
extends AffordanceModel {
    private static final Set<HttpMethod> ENTITY_ALTERING_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private static final Set<HttpMethod> REQUIRED_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT);
    private final List<HalFormsProperty> inputProperties = this.determineInputs();

    public HalFormsAffordanceModel(String name, Link link, HttpMethod httpMethod, ResolvableType inputType, List<QueryParameter> queryMethodParameters, ResolvableType outputType) {
        super(name, link, httpMethod, inputType, queryMethodParameters, outputType);
    }

    private List<HalFormsProperty> determineInputs() {
        if (!ENTITY_ALTERING_METHODS.contains(this.getHttpMethod())) {
            return Collections.emptyList();
        }
        return PropertyUtils.findPropertyNames(this.getInputType()).stream().map(propertyName -> new HalFormsProperty().withName((String)propertyName).withRequired(REQUIRED_METHODS.contains(this.getHttpMethod()))).collect(Collectors.toList());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HalFormsAffordanceModel)) {
            return false;
        }
        HalFormsAffordanceModel other = (HalFormsAffordanceModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<HalFormsProperty> this$inputProperties = this.getInputProperties();
        List<HalFormsProperty> other$inputProperties = other.getInputProperties();
        return !(this$inputProperties == null ? other$inputProperties != null : !((Object)this$inputProperties).equals(other$inputProperties));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HalFormsAffordanceModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<HalFormsProperty> $inputProperties = this.getInputProperties();
        result = result * 59 + ($inputProperties == null ? 43 : ((Object)$inputProperties).hashCode());
        return result;
    }

    @Generated
    public List<HalFormsProperty> getInputProperties() {
        return this.inputProperties;
    }
}

